/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.event;

import com.cisco.aci.vcplugin.event.Observer;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.model.EventType;
import com.cisco.aci.vcplugin.swagger.model.ModelObject;
import com.cisco.aci.vcplugin.swagger.model.VcpEvent;
import com.google.gson.Gson;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.SerializationUtils;

public class VcpObserver
implements Observer,
Serializable {
    private static final List<String> ALL_APIS = Collections.unmodifiableList(Arrays.asList("*"));
    private static final List<String> ALL_MO_TYPES = Collections.unmodifiableList(Arrays.asList("*"));
    private transient List<Object> _pendingNotifications = new ArrayList<Object>();
    private transient List<Observer> _subscriptions = new ArrayList<Observer>();
    private transient List<Observer> _subscribers = new ArrayList<Observer>();
    private transient boolean _bubbleEvents = true;
    private transient VcpLogger log = new VcpLogger();

    @Override
    public void onUpdate(Observer source, Object data) {
        if (this._bubbleEvents) {
            this.notifyObservers(data);
        }
    }

    @Override
    public void observe(Observer o) {
        this._subscriptions.add(o);
        o.addObserver(this);
    }

    @Override
    public void stopObserving(Observer o) {
        this._subscriptions.remove(o);
        o.removeObserver(o);
    }

    @Override
    public void addObserver(Observer o) {
        this._subscribers.add(o);
        if (this._pendingNotifications.size() > 0) {
            for (Object data : this._pendingNotifications) {
                o.onUpdate(this, data);
            }
            this._pendingNotifications.clear();
        }
    }

    @Override
    public void removeObserver(Observer o) {
        this._subscribers.remove(o);
    }

    @Override
    public void notifyObservers(Object data) {
        if (this._subscribers.size() > 0) {
            for (Observer o : this._subscribers) {
                o.onUpdate(this, data);
            }
        } else {
            this._pendingNotifications.add(data);
        }
    }

    public final VcpEvent newEvent(VcpEvent e) {
        this.log.info("triggering event:" + e.getEventType().toString() + ", apis=" + e.getAffectedApis() + ", affectedMos=" + e.getAffectedMoTypes());
        e.setEmitter(this);
        this.notifyObservers(e);
        return e;
    }

    public final VcpEvent dispatchRefreshAllEvent() {
        return this.dispatchRefreshEvent(null);
    }

    public final VcpEvent dispatchRefreshEvent(List<String> affectedMoTypes) {
        return this.newEvent(EventType.REFRESH, null, affectedMoTypes, null);
    }

    public final VcpEvent newEvent(EventType type, String[] apis, List<String> affectedMoTypes, ModelObject data) {
        VcpEvent event = new VcpEvent().id(UUID.randomUUID().toString()).date(new Timestamp(System.currentTimeMillis()).getTime()).eventType(type).data(data == null ? null : this.deepClone(data)).affectedMoTypes(affectedMoTypes == null ? ALL_MO_TYPES : affectedMoTypes).source(this.getClass().getName());
        if (apis != null) {
            event.setAffectedApis(Arrays.asList(apis));
        } else if (affectedMoTypes == null) {
            event.setAffectedApis(ALL_APIS);
        }
        return this.newEvent(event);
    }

    protected void disableEventBubbling() {
        this._bubbleEvents = false;
    }

    public Object deepClone(Serializable object) {
        return SerializationUtils.clone((Serializable)object);
    }

    protected String toJSON(Object o) {
        return new Gson().toJson(o);
    }
}

