/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcpLogger {
    private static boolean SYSOUT_LOG = true;
    private static final Log _log = LogFactory.getLog(VcpLogger.class);
    private long _startTime;
    private String prefix = "";

    public VcpLogger() {
    }

    public VcpLogger(String prefix) {
        this.prefix = prefix;
    }

    public void startPerf() {
        this._startTime = System.nanoTime();
    }

    public void stopPerf() {
        long endTime = System.nanoTime();
        long duration = (endTime - this._startTime) / 1000000L;
        StackTraceElement stack = Thread.currentThread().getStackTrace()[2];
        this.info("execution took " + duration + "ms for " + stack.getMethodName());
        this._startTime = 0L;
    }

    public void info(String message) {
        _log.info((Object)(this.getPrefixes() + message));
        if (SYSOUT_LOG) {
            System.out.println(this.getPrefixes() + message);
        }
    }

    public void warn(String message) {
        _log.warn((Object)(this.getPrefixes() + message));
        if (SYSOUT_LOG) {
            System.out.println(this.getPrefixes() + message);
        }
    }

    public void error(Exception e) {
        e.printStackTrace();
        this.error(e.getMessage());
    }

    public void error(String message) {
        _log.error((Object)(this.getPrefixes() + message));
        if (SYSOUT_LOG) {
            System.out.println(this.getPrefixes() + message);
        }
    }

    public String getPrefixes() {
        StackTraceElement stack = Thread.currentThread().getStackTrace()[3];
        String className = stack.getClassName();
        String[] segs = className.split("\\.");
        String pref = this.prefix;
        if (!"".equals(pref)) {
            pref = pref + "  ";
        }
        return "vcplugin||" + this.prefix + "||" + segs[segs.length - 1] + "||" + stack.getMethodName() + "():" + stack.getLineNumber() + "||";
    }
}

