/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.mvc;

import com.cisco.aci.vcplugin.mvc.QueryUtil;
import com.cisco.aci.vcplugin.services.SampleActionService;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/actions"})
public class ActionsController {
    private static final Log _logger = LogFactory.getLog(ActionsController.class);
    private final String RESOURCE_BUNDLE = "__bundleName__";
    private final SampleActionService _actionService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public ActionsController(SampleActionService actionService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._actionService = actionService;
        this._objectReferenceService = objectReferenceService;
        QueryUtil.setObjectReferenceService(objectReferenceService);
    }

    public ActionsController() {
        this._actionService = null;
        this._objectReferenceService = null;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> invoke(@RequestParam(value="actionUid", required=true) String actionUid, @RequestParam(value="targetIds", required=false) String targetIds, @RequestParam(value="json", required=false) String json) throws Exception {
        Object objectRef = null;
        if (targetIds != null) {
            String[] objectIds = targetIds.split(",");
            if (objectIds.length > 1) {
                _logger.warn((Object)("Action " + actionUid + " called with " + objectIds.length + " target objects, will use only the first one"));
            }
            if ((objectRef = this._objectReferenceService.getReference(objectIds[0])) == null) {
                String errorMsg = "Error in action " + actionUid + ", object not found with id: " + objectIds[0];
                _logger.error((Object)errorMsg);
                throw new Exception(errorMsg);
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (actionUid.equals("com.cisco.aci.vcplugin.sampleAction1")) {
            Boolean result = this._actionService.sampleAction1(objectRef);
            resultMap.put("result", result);
        } else if (actionUid.equals("com.cisco.aci.vcplugin.sampleAction2")) {
            Boolean result = this._actionService.sampleAction2(objectRef);
            resultMap.put("result", result);
        } else if (!actionUid.equals("com.cisco.aci.vcplugin.sampleAction3")) {
            throw new Exception("Action no implemented! " + actionUid);
        }
        return resultMap;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleException(Exception ex, HttpServletResponse response) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("message", ex.getMessage());
        if (ex.getCause() != null) {
            errorMap.put("cause", ex.getCause().getMessage());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        errorMap.put("stackTrace", sw.toString());
        return errorMap;
    }
}

