/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.mvc;

import com.cisco.aci.vcplugin.services.EchoService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/services"})
public class ServicesController {
    private static final Log _logger = LogFactory.getLog(ServicesController.class);
    private final EchoService _echoService;

    @Autowired
    public ServicesController(@Qualifier(value="echoService") EchoService echoService) {
        this._echoService = echoService;
    }

    public ServicesController() {
        this._echoService = null;
    }

    @RequestMapping(value={"/echo"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> echo(@RequestParam(value="message", required=true) String message) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("message", this._echoService.echo(message));
        return result;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleException(Exception ex, HttpServletResponse response) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("message", ex.getMessage());
        if (ex.getCause() != null) {
            errorMap.put("cause", ex.getCause().getMessage());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        errorMap.put("stackTrace", sw.toString());
        return errorMap;
    }
}

