/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.session;

import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.session.SessionManager;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aciPluginServices.vim.VimConnection;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionManagerImpl
implements SessionManager {
    private final VcpLogger log = new VcpLogger();
    private final UserSessionService _userSessionService;
    private Map<String, List<Vcenter>> _vcMap;

    public SessionManagerImpl(UserSessionService userSessionService) {
        this._userSessionService = userSessionService;
        this._vcMap = new ConcurrentHashMap<String, List<Vcenter>>();
        this.log.info("initialized");
        VimConnection.initVimService();
    }

    @Override
    public String getUsername() {
        return this._userSessionService.getUserSession().userName;
    }

    @Override
    public List<Vcenter> getSessionVcenters(String username) {
        return this._vcMap.get(username);
    }

    @Override
    public void loadSessionVCenters() {
        String username = this.getUsername();
        ServerInfo[] servers = this._userSessionService.getUserSession().serversInfo;
        ArrayList<Vcenter> vCenters = new ArrayList<Vcenter>();
        for (ServerInfo s : servers) {
            Vcenter vc = new Vcenter();
            vc.setGuid(s.serviceGuid);
            vc.setName(s.name);
            vc.setSessionCookie(s.sessionCookie);
            vc.setUrl(s.serviceUrl);
            vc.setVersion(s.version);
            vCenters.add(vc);
            this.log.info("seen vc " + vc.getUrl() + " with session id " + vc.getSessionCookie());
        }
        this._vcMap.put(username, vCenters);
    }
}

