/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.api.DomainApi;
import com.cisco.aci.vcplugin.swagger.model.Epg;
import com.cisco.aci.vcplugin.swagger.model.VmmDomain;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DomainApiController
implements DomainApi {
    private static final Logger log = LoggerFactory.getLogger(DomainApiController.class);
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;

    @Autowired
    public DomainApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    @Override
    public ResponseEntity<List<Epg>> fabricsIdDomainsDomNameEpgsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the domain", required=true) @PathVariable(value="domName") String domName, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<VmmDomain>> fabricsIdDomainsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="fetch only ave domains when true.", defaultValue="false") @Valid @RequestParam(value="aveOnly", required=false, defaultValue="false") Boolean aveOnly, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

