/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.api.TaskApi;
import com.cisco.aci.vcplugin.swagger.model.StartTaskData;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskOperation;
import com.cisco.aci.vcplugin.swagger.model.TaskSchedulingProfile;
import com.cisco.aci.vcplugin.swagger.model.TaskStatus;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TaskApiController
implements TaskApi {
    private static final Logger log = LoggerFactory.getLogger(TaskApiController.class);
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;

    @Autowired
    public TaskApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    @Override
    public ResponseEntity<List<Task>> tasksGet(@ApiParam(value="Filter by task operation (NEW_AVE, REMOVE_AVE, CREATE_TENANT, ...)") @Valid @RequestParam(value="operations", required=false) List<TaskOperation> operations, @ApiParam(value="Filter by task entity") @Valid @RequestParam(value="entity", required=false) String entity, @ApiParam(value="Filter by the status status (RUNNING, FAILED, ...)") @Valid @RequestParam(value="status", required=false) List<TaskStatus> status, @ApiParam(value="Filter task that are acknowledged or not") @Valid @RequestParam(value="acked", required=false) Boolean acked) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> tasksIdAcknowledgePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> tasksIdCancelPost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> tasksIdGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> tasksMoIdLatestGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Void> tasksPost(@ApiParam(value="The list of Tasks to start", required=true) @Valid @RequestBody List<StartTaskData> tasks) {
        String accept = this.request.getHeader("Accept");
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Void> tasksSchedulingProfilesNameDelete(@ApiParam(value="Name", required=true) @PathVariable(value="name") String name) {
        String accept = this.request.getHeader("Accept");
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<TaskSchedulingProfile> tasksSchedulingProfilesNameGet(@ApiParam(value="Name", required=true) @PathVariable(value="name") String name) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("{  \"name\" : \"name\",  \"maxConcurrentTask\" : 0,  \"tasks\" : [ \"\", \"\" ]}", TaskSchedulingProfile.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<TaskSchedulingProfile> tasksSchedulingProfilesNamePost(@ApiParam(value="Name", required=true) @PathVariable(value="name") String name, @ApiParam(value="The task scheduling profile", required=true) @Valid @RequestBody TaskSchedulingProfile taskSchedulingProfile) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("{  \"name\" : \"name\",  \"maxConcurrentTask\" : 0,  \"tasks\" : [ \"\", \"\" ]}", TaskSchedulingProfile.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

