/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Bd;
import com.cisco.aci.vcplugin.swagger.model.Subnet;
import com.cisco.aci.vcplugin.swagger.model.Vrf;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;
import java.util.List;

public class CreateBdTask
extends ATask {
    private transient Bd _inputBd;
    private transient ApicSdk _sdk;

    public CreateBdTask() {
        this.setName("Create BD");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("create");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Bd.class);
        this._inputBd = (Bd)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputBd.getFabricId());
        this.setProgress(20);
    }

    public void create() throws AbortTaskException {
        String tenantName = this._inputBd.getParentTenant().getName();
        String bdName = this._inputBd.getName();
        String description = this._inputBd.getDescr();
        List<Subnet> subnetList = this._inputBd.getSubnetList();
        Vrf vrf = this._inputBd.getVrf();
        boolean createOnly = this._inputBd.isCreateOnly();
        try {
            this._sdk.createBd(bdName, description, subnetList, tenantName, vrf, createOnly);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

