/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Entry;
import com.cisco.aci.vcplugin.swagger.model.Filter;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;
import java.util.List;

public class CreateFilterTask
extends ATask {
    private transient Filter _inputFilter;
    private transient ApicSdk _sdk;

    public CreateFilterTask() {
        this.setName("Create Filter");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("create");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Filter.class);
        this._inputFilter = (Filter)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputFilter.getFabricId());
        this.setProgress(20);
    }

    public void create() throws AbortTaskException {
        String filterName = this._inputFilter.getName();
        String tenantName = this._inputFilter.getParentTenant().getName();
        String description = this._inputFilter.getDescr();
        List<Entry> entries = this._inputFilter.getEntries();
        boolean createOnly = this._inputFilter.isCreateOnly();
        try {
            this._sdk.createFilter(filterName, description, entries, tenantName, createOnly);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

