/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Bd;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;

public class DeleteBdTask
extends ATask {
    private transient Bd _inputBd;
    private transient ApicSdk _sdk;

    public DeleteBdTask() {
        this.setName("Delete BD");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("delete");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Bd.class);
        this._inputBd = (Bd)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputBd.getFabricId());
        this.setProgress(20);
    }

    public void delete() throws AbortTaskException {
        String tenantName = this._inputBd.getParentTenant().getName();
        String bdName = this._inputBd.getName();
        try {
            this._sdk.deleteBd(bdName, tenantName);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

