/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Contract;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;

public class DeleteContractTask
extends ATask {
    private transient Contract _inputContract;
    private transient ApicSdk _sdk;

    public DeleteContractTask() {
        this.setName("Delete Contract");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("delete");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Contract.class);
        this._inputContract = (Contract)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputContract.getFabricId());
        this.setProgress(20);
    }

    public void delete() throws AbortTaskException {
        String contractName = this._inputContract.getName();
        String tenantName = this._inputContract.getParentTenant().getName();
        try {
            this._sdk.deleteContract(contractName, tenantName);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

