/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.Constants;
import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.api.StorageApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.storage.PersistentSettings;
import com.cisco.aci.vcplugin.swagger.model.Certificate;
import com.cisco.aci.vcplugin.swagger.model.Fabric;
import com.cisco.aci.vcplugin.swagger.model.LoginSettings;
import com.cisco.aci.vcplugin.swagger.model.StoredApicSettings;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.aci.vcplugin.validators.CertificateValidator;
import com.cisco.aci.vcplugin.validators.VcpObjectValidator;
import com.cisco.aciPluginServices.acivtool.AciVTool;
import com.cisco.apic.ApicHandle;
import com.cisco.apic.mo.moCount;
import com.cisco.apic.util.ApicMoOperationException;
import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.SystemUtils;

public class RegisterFabricTask
extends ATask {
    private static transient VcpLogger log = new VcpLogger();
    private transient LoginSettings _settings;
    private transient URL _url;
    private transient ApicHandle _handle;

    public RegisterFabricTask() {
        this.setName("Register Fabric");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("connect");
        this.addStage("save");
    }

    public void validate() throws AbortTaskException, ApicMoOperationException {
        Optional<String> errorMsgs;
        String urlStr;
        log.info("In stage validate");
        this.validateInput(LoginSettings.class);
        this._settings = (LoginSettings)this.getInput();
        if (this._settings.getCertificate() == null && this._settings.getPassword() == null) {
            this.failTask("A password or a certificate must be specfied");
        }
        if ((urlStr = this._settings.getUrl()).startsWith("http://")) {
            this.failTask("HTTP usage is not supported");
        }
        if (!urlStr.startsWith("https://")) {
            this._settings.url("https://" + this._settings.getUrl());
        }
        this._url = null;
        try {
            this._url = new URL(this._settings.getUrl());
        }
        catch (MalformedURLException e) {
            this.failTask(e);
        }
        String username = this.getInitiator();
        String inputUrl = this._settings.getUrl();
        String inputIp = this.getIpFromURL(inputUrl);
        String fabricName = this._settings.getFabricName();
        Map<String, ApicSdk> map = AaaApiController.getUserHandleMap(username);
        if (map != null) {
            for (ApicSdk sdk : map.values()) {
                String existingFabricIp;
                if (sdk.getFabric().getName().equals(this._settings.getFabricName())) {
                    this.failTask("Fabric with name " + fabricName + " is already registered by current VC user " + username + " using URL " + sdk.getApicUrl());
                }
                if (!(existingFabricIp = this.getIpFromURL(sdk.getApicUrl())).equals(inputIp)) continue;
                this.failTask("Fabric with URL " + inputUrl + " is already registered by current VC user " + username + " using URL " + sdk.getApicUrl());
            }
        }
        if (this._settings.getCertificate() != null && (errorMsgs = VcpObjectValidator.validateObject(new CertificateValidator(true), this._settings.getCertificate(), "certificate")).isPresent()) {
            this.failTask(errorMsgs.get());
        }
        this.setProgress(10);
    }

    public void connect() throws AbortTaskException {
        boolean noSsl = "http".equals(this._url.getProtocol().toLowerCase());
        int port = this._url.getPort();
        if (port == -1) {
            port = noSsl ? 80 : 443;
        }
        String host = this._url.getHost();
        Certificate cert = this._settings.getCertificate();
        boolean isCertAuth = Optional.ofNullable(cert).isPresent();
        String userName = this._settings.getUsername();
        String authMethod = isCertAuth ? cert.getType().name() : "username/pw";
        log.info("login to apic: " + this._settings.getUrl() + " with apic username: " + userName + " with authentication method: " + authMethod);
        ApicHandle handle = new ApicHandle();
        try {
            if (!isCertAuth) {
                boolean loggedIn = handle.login(host, userName, this._settings.getPassword(), noSsl, port, false);
                log.info("Logged In=" + loggedIn);
            } else {
                String vcUser = this.getInitiator();
                handle = RegisterFabricTask.getHandleWithCertLogin(this._settings, vcUser, this._url, port);
            }
        }
        catch (Exception e) {
            this.failTask(e);
            e.printStackTrace();
            log.info(e.getMessage());
        }
        this.setProgress(60);
        log.info("login successful");
        if (handle.getVersion() != null) {
            log.info("apic version:" + handle.getVersion().getVersion());
        } else {
            log.warn("could not resolve the apic version");
        }
        this._handle = handle;
    }

    public void save() throws AbortTaskException, ApicMoOperationException {
        File acivtoolBinary;
        String uuid = UUID.randomUUID().toString();
        AaaApiController.insertApicHandle(this.getInitiator(), uuid, this._handle, this._settings.getUsername(), this._settings.getPassword(), this._settings.getUrl(), this._settings.getFabricName());
        log.info("handle with uuid " + uuid + " has been added to the map");
        Fabric f = AaaApiController.getApicHandle(this.getInitiator(), uuid).getFabric();
        this.addEntity(f);
        try {
            AciVTool aciVTool = new AciVTool(PersistentSettings.getSettingsFileFolder(), Constants.JAR_PATH, Constants.PLUGIN_VERSION);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error("Cannot initiliaze acivtool object ");
        }
        String acivtoolFolder = PersistentSettings.getSettingsFileFolder();
        String acivtoolPath = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            acivtoolPath = acivtoolFolder + "\\acivtool___" + Constants.PLUGIN_VERSION + "__.exe";
            log.info("Checking acivtool exists in path : " + acivtoolPath);
        } else {
            acivtoolPath = acivtoolFolder + "/acivtool___" + Constants.PLUGIN_VERSION + "__";
            log.info("Checking acivtool exists in path : " + acivtoolPath);
        }
        if (acivtoolPath != null && (acivtoolBinary = new File(acivtoolPath)).exists()) {
            log.info("acivtool binary now exists in location " + acivtoolPath);
            acivtoolBinary.setReadable(true);
            acivtoolBinary.setExecutable(true);
            acivtoolBinary.setWritable(true);
        }
        this.saveToStorage(uuid);
    }

    private void saveToStorage(String uuid) {
        StoredApicSettings apicSettings = new StoredApicSettings();
        apicSettings.setHostname(this._url.getHost());
        apicSettings.setUsername(this._settings.getUsername());
        apicSettings.setPort(this._url.getPort());
        apicSettings.setProtocol(this._url.getProtocol());
        Certificate cert = this._settings.getCertificate();
        boolean hasCert = Optional.ofNullable(cert).isPresent();
        if (hasCert) {
            apicSettings.setCertificate(cert);
        }
        String vcUser = this.getInitiator();
        StorageApiController.updateApicSettings(vcUser, uuid, apicSettings);
    }

    public static ApicHandle getHandleWithCertLogin(LoginSettings settings, String vcUser, URL url, int port) throws Exception {
        boolean retrievedMos;
        String pw;
        Certificate cert = settings.getCertificate();
        String username = settings.getUsername();
        String apicHost = url.getHost();
        boolean selfSignedCert = cert.getType() == Certificate.TypeEnum.SELF_SIGNED;
        ApicHandle handle = selfSignedCert ? RegisterFabricTask.getHandleWithSelfSignedCert(cert, username) : RegisterFabricTask.getHandleWithCac(settings, vcUser, apicHost);
        boolean validLogin = handle.login(apicHost, username, pw = "dummypw", false, port, false);
        if (!validLogin) {
            throw new Exception("Unable to login using cert auth");
        }
        List mos = handle.getManagedObjects(null, "polUni", null, null, null, null, null, null, null, "count");
        boolean bl = retrievedMos = mos != null && !mos.isEmpty() && mos.get(0) instanceof moCount;
        if (!retrievedMos) {
            throw new Exception("Unable to retrieve polUni using cert auth");
        }
        return handle;
    }

    private static ApicHandle getHandleWithSelfSignedCert(Certificate cert, String userName) throws Exception {
        String privateKey;
        log.info("Setting self-signed fields");
        boolean hasSalt = Optional.ofNullable(cert.getSalt()).isPresent();
        if (hasSalt) {
            privateKey = PersistentSettings.decryptPrivateKey(cert);
        } else {
            privateKey = cert.getPrivateKey().replaceAll("\\r", "\n");
            privateKey = privateKey.replaceAll("\\n", "\n");
        }
        ApicHandle handle = new ApicHandle();
        handle.setCertificate(privateKey, cert.getName(), userName);
        return handle;
    }

    private static ApicHandle getHandleWithCac(LoginSettings settings, String vcUser, String apicHost) throws Exception {
        log.info("Setting CAC fields");
        if (!PersistentSettings.storeCacFile(settings, vcUser, apicHost)) {
            throw new Exception("Unable to save CAC file");
        }
        String apicUser = settings.getUsername();
        String filename = PersistentSettings.getCacFilename(apicUser, vcUser, apicHost);
        ApicHandle handle = new ApicHandle();
        String passphrase = settings.getCertificate().getPassphrase();
        handle.setCacAuthFromCertFile(filename, passphrase);
        if (!handle.validateCacCertFile()) {
            throw new Exception("Unable to load CAC file to Java KeyStore");
        }
        return handle;
    }

    private String getIpFromURL(String url) {
        try {
            return InetAddress.getByName(new URL(url).getHost()).getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

