/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.Constants;
import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.storage.PersistentSettings;
import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import com.cisco.aci.vcplugin.swagger.model.HostAveRemoveConfig;
import com.cisco.aci.vcplugin.swagger.model.VmmDomain;
import com.cisco.aci.vcplugin.task.NewAveTask;
import com.cisco.aci.vcplugin.task.engine.AAciVToolTask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.aciPluginServices.acivtool.AciVTool;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoveAveTask
extends AAciVToolTask {
    private transient HostAveRemoveConfig _taskConfig;
    private transient ApicSdk _apicHandle;
    private transient VCenterSdk _vcHandle;
    private transient VmmDomain _vmmDomain;
    private transient EsxHost _esxHost;
    private final transient Log log = LogFactory.getLog(NewAveTask.class);

    public RemoveAveTask() {
        this.setName("Remove AVE");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("removeAve");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(HostAveRemoveConfig.class);
        this._taskConfig = (HostAveRemoveConfig)this.getInput();
        this._vmmDomain = this._taskConfig.getDomain();
        this.addEntity(this._vmmDomain);
        this._esxHost = this._taskConfig.getHost();
        this._apicHandle = AaaApiController.getApicHandle(this.getInitiator(), this._vmmDomain.getFabricId());
        this._vcHandle = AaaApiController.getVCHandle(this.getInitiator(), this._esxHost.getVcId());
    }

    public void removeAve() throws AbortTaskException, InterruptedException {
        this.log.info((Object)"removing ave");
        this.startVCTask(this._vcHandle, this._esxHost, "com.cisco.aci.avs.tasks.svmuninstall");
        try {
            AciVTool vtool = new AciVTool(PersistentSettings.getSettingsFileFolder(), Constants.JAR_PATH, Constants.PLUGIN_VERSION);
            this.log.info((Object)("Using AciVTool version : " + Constants.PLUGIN_VERSION));
            URI vcURL = new URI(this._vcHandle.getVcenterInfo().getUrl());
            vtool.setCredentialAuth(vcURL.getHost(), this._vcHandle.getUsername(), this._vcHandle.getPassword());
            this.setProgress(2);
            vtool.AveRemove(this._esxHost.getName(), this._vmmDomain.getName(), this._taskConfig.isEnterMaintenance().booleanValue());
        }
        catch (Exception e) {
            this.handleAciVToolException(e);
        }
    }

    @Override
    public Map<Integer, String> getProgressMessageMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(2, "Validating configuration");
        map.put(10, "Adding affinity rule on DRS cluster");
        map.put(30, "Waiting for all VMs to move out of the host");
        map.put(50, "Powering off the AVE VM");
        map.put(70, "Deleting the AVE VM");
        return map;
    }
}

