/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.Constants;
import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApiSpecUtil;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.storage.PersistentSettings;
import com.cisco.aci.vcplugin.swagger.model.ApiSpec;
import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import com.cisco.aci.vcplugin.swagger.model.VMwareMo;
import com.cisco.aci.vcplugin.swagger.model.VPodDeleteConfig;
import com.cisco.aci.vcplugin.task.engine.AAciVToolTask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.aciPluginServices.acivtool.AciVTool;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoveVPodTask
extends AAciVToolTask {
    private transient VPodDeleteConfig _taskConfig;
    private transient String _podId;
    private transient EsxHost _esxHost;
    private transient VCenterSdk _vcHandle;
    private final transient Log log = LogFactory.getLog(RemoveVPodTask.class);

    public RemoveVPodTask() {
        this.setName("Remove VPod");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("getHost");
        this.addStage("removeVPod");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(VPodDeleteConfig.class);
        this._taskConfig = (VPodDeleteConfig)this.getInput();
        this._podId = this._taskConfig.getPodId();
        this._vcHandle = AaaApiController.getVCHandle(this.getInitiator(), this._taskConfig.getHost().getVcId());
        if (this._vcHandle == null) {
            this.failTask("Failed to get the vCenter handle");
        }
    }

    public void removeVPod() throws AbortTaskException, InterruptedException {
        this.startVCTask(this._vcHandle, this._esxHost, "com.cisco.aci.avs.tasks.vpod.remove");
        try {
            AciVTool vtool = new AciVTool(PersistentSettings.getSettingsFileFolder(), Constants.JAR_PATH, Constants.PLUGIN_VERSION);
            this.log.info((Object)("Using AciVTool version : " + Constants.PLUGIN_VERSION));
            URI vcURL = new URI(this._vcHandle.getVcenterInfo().getUrl());
            vtool.setCredentialAuth(vcURL.getHost(), this._vcHandle.getUsername(), this._vcHandle.getPassword());
            this.setProgress(2);
            vtool.VPodRemove(this._podId, this._esxHost.getName());
        }
        catch (Exception e) {
            this.handleAciVToolException(e);
        }
    }

    public void getHost() throws AbortTaskException, InterruptedException {
        VMwareMo moRef = this._taskConfig.getHost();
        if (moRef == null) {
            this.failTask("No ESX host was specified");
        }
        try {
            ApiSpec spec = ApiSpecUtil.moIdSpec(moRef.getOid());
            List<EsxHost> hosts = this._vcHandle.getEsxHosts(spec);
            if (hosts == null || hosts.size() == 0) {
                this.failTask("Failed to resolve ESX with oid " + moRef.getOid());
            }
            this._esxHost = hosts.get(0);
        }
        catch (Exception e) {
            this.failTask(e);
        }
    }

    @Override
    public Map<Integer, String> getProgressMessageMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(2, "Retrieving vPOD Virtual Machines");
        map.put(10, "Verifying vPOD Virtual Machines");
        map.put(20, "Deleting Virtual Machines");
        return map;
    }
}

