/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task.engine;

import com.cisco.aci.vcplugin.swagger.model.AciMo;
import com.cisco.aci.vcplugin.swagger.model.EventType;
import com.cisco.aci.vcplugin.swagger.model.ModelObject;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskStage;
import com.cisco.aci.vcplugin.swagger.model.TaskStatus;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.aci.vcplugin.task.engine.TaskManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ATask
extends Task
implements Runnable {
    private static final String TASK_MO = Task.class.getSimpleName();
    private static final String INPUT_MISSING_ERROR = "Task input data is missing";
    private static final String INPUT_INVALID_TYPE_ERROR = "Task input data type is incorrect";
    private final transient Thread _t;
    private transient boolean _canceling = false;
    private transient TaskManager _tm;
    private transient String[] _apis;
    private transient List<String> _affectedMoTypes;
    private transient String _targetMoId = null;
    protected transient Log log;

    public ATask() {
        this.setId(UUID.randomUUID().toString());
        this.log = LogFactory.getLog(ATask.class);
        this.setCreationTime(new Timestamp(System.currentTimeMillis()).getTime());
        this.setStatus(TaskStatus.CREATED);
        this.setProgress(0);
        this.setMoUrl("/tasks/" + this.getId());
        this.setStages(new LinkedList<TaskStage>());
        this.setEntities(new ArrayList<ModelObject>());
        this._t = new Thread(this);
        this._apis = new String[]{"/tasks", "/tasks/" + this.getId()};
    }

    @Override
    public final void setInput(Object input) {
        super.setInput(input);
        if (input instanceof AciMo) {
            this.setAffectedMo((AciMo)input);
        }
    }

    protected void setAffectedMo(AciMo mo) {
        this._affectedMoTypes = mo == null ? null : Arrays.asList(TASK_MO, mo.getMoType());
    }

    public List<String> getAffectedMoTypes() {
        return this._affectedMoTypes;
    }

    private void dispatchRefreshEvent() {
        this.dispatchRefreshEvent(this.getAffectedMoTypes());
    }

    private void dispatchUpdateEvent() {
        this.newEvent(EventType.MO_UPDATE, this._apis, this.getAffectedMoTypes(), this);
    }

    public ATask withTarget(ModelObject mo) {
        this.setTargetMoId(mo.getId());
        this.addEntitiesItem(mo);
        return this;
    }

    public ATask withSchedulingProfile(String profileName) {
        this.setSchedulingProfileName(profileName);
        return this;
    }

    public ATask schedule() {
        this._tm.scheduleTask(this);
        this.dispatchUpdateEvent();
        return this;
    }

    public void setTaskManager(TaskManager tm) {
        this._tm = tm;
    }

    public void acknowledge() {
        this.setAcknowledged(true);
        this.dispatchRefreshEvent();
    }

    public void start() {
        if (this.getInput() != null) {
            this.log.info((Object)("starting task with input:" + this.getInput().toString()));
        } else {
            this.log.info((Object)"starting task with null input");
        }
        this._t.start();
    }

    public void join() throws InterruptedException {
        this._t.join();
    }

    public void cancel() {
        if (!this.isCancelable().booleanValue()) {
            this.log.warn((Object)"tried to cancel the task marked as non cancelable!");
            return;
        }
        this.log.info((Object)"marking task for cancellation");
        this._canceling = true;
        if (this.getStatus() == TaskStatus.QUEUED) {
            this.doCancel();
        }
    }

    @Override
    public void run() {
        this.setStartTime(new Timestamp(System.currentTimeMillis()).getTime());
        this.log.info((Object)"task starting execution");
        for (TaskStage stage : this.getStages()) {
            try {
                if (this._canceling) {
                    this.log.info((Object)"task is marked for cancelation, skipping remaning stages");
                    break;
                }
                Method stageMethod = this.getClass().getMethod(stage.getName(), new Class[0]);
                this.log.info((Object)("invoking stage " + stage.getName()));
                this.setMessage("Running stage " + stage.getName());
                stageMethod.invoke((Object)this, new Object[0]);
                stage.setCompleted(true);
                if (this.getStatus() == TaskStatus.RUNNING) {
                    this.newEvent(EventType.MO_UPDATE, this._apis, this.getAffectedMoTypes(), this);
                }
                this.log.info((Object)("completed stage " + stage.getName()));
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof AbortTaskException) {
                    this.log.info((Object)"task was aborted");
                    break;
                }
                try {
                    this.failTask(e);
                }
                catch (AbortTaskException abortTaskException) {}
                break;
            }
            catch (Exception e) {
                try {
                    this.failTask(e);
                }
                catch (AbortTaskException abortTaskException) {}
                break;
            }
        }
        this.doCancel();
        this.log.info((Object)"task ended execution");
        if (this.getStatus() == TaskStatus.RUNNING) {
            this.successTask();
        }
        this.setEndTime(new Timestamp(System.currentTimeMillis()).getTime());
    }

    protected void doCancel() {
        if (this._canceling) {
            this.onCancel();
            this.setStatus(TaskStatus.FAILED);
            this.setCancelable(false);
            this.setMessage("Task was cancelled by a user");
        }
    }

    protected void onCancel() {
        this.log.info((Object)"Generic onCancel()");
    }

    protected void failTask(String msg) throws AbortTaskException {
        this.log.error((Object)msg);
        this.setMessage(msg);
        this.setStatus(TaskStatus.FAILED);
        this.setCancelable(false);
        this.dispatchRefreshEvent();
        throw new AbortTaskException(msg);
    }

    protected void failTask(Exception e) throws AbortTaskException {
        this.log.error((Object)e.getMessage());
        e.printStackTrace();
        this.setMessage(e.getMessage());
        this.setStatus(TaskStatus.FAILED);
        this.setCancelable(false);
        this.dispatchRefreshEvent();
        throw new AbortTaskException(e.getMessage());
    }

    protected void successTask() {
        this.setProgress(100);
        this.setMessage("Task completed successfully");
        this.setStatus(TaskStatus.COMPLETED);
        this.setCancelable(false);
        this.dispatchRefreshEvent();
    }

    protected void addStage(String name) {
        TaskStage stage = new TaskStage();
        stage.setName(name);
        stage.setCompleted(false);
        this.getStages().add(stage);
    }

    public void updateProgress(Integer progress) {
        if (progress == null || progress.equals(this.getProgress())) {
            return;
        }
        this.setProgress(progress);
        this.dispatchUpdateEvent();
    }

    public void addEntity(ModelObject mo) {
        if (this.getEntities().contains(mo)) {
            return;
        }
        this.addEntitiesItem(mo);
        this.dispatchUpdateEvent();
    }

    public void updateMessage(String message) {
        if (message != null && message.equals(this.getMessage())) {
            return;
        }
        this.setMessage(message);
        this.dispatchUpdateEvent();
    }

    public String[] apis() {
        return this._apis;
    }

    protected void validateInput(Class cls) throws AbortTaskException {
        Object input = this.getInput();
        if (input == null) {
            this.failTask(INPUT_MISSING_ERROR);
        }
        if (!cls.isInstance(input)) {
            String expectedError = String.format("Expected input type: %s Actual input type: %s", cls.getSimpleName(), input.getClass().getSimpleName());
            String errorMsg = String.format("%s. %s", INPUT_INVALID_TYPE_ERROR, expectedError);
            this.failTask(errorMsg);
        }
    }

    public String getTargetMoId() {
        return this._targetMoId;
    }

    public void setTargetMoId(String targetMoId) {
        this._targetMoId = targetMoId;
    }
}

