/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.validators;

import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.log.VcpLogger;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class VcpObjectValidator {
    private static final VcpLogger log = new VcpLogger();

    public static Optional<ResponseEntity> validateObjectRes(Validator validator, Object obj, String objName) {
        Optional<String> errorMessages = VcpObjectValidator.validateObject(validator, obj, objName);
        if (!errorMessages.isPresent()) {
            return Optional.empty();
        }
        ResponseEntity error = ResponseUtils.getErrorResponse(errorMessages.get(), HttpStatus.BAD_REQUEST);
        return Optional.of(error);
    }

    public static Optional<String> validateObject(Validator validator, Object obj, String objName) {
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(obj, objName);
        ValidationUtils.invokeValidator((Validator)validator, (Object)obj, (Errors)errors);
        if (!errors.hasErrors()) {
            return Optional.empty();
        }
        StringBuilder errorMessages = new StringBuilder();
        List objErrors = errors.getAllErrors();
        for (ObjectError err : objErrors) {
            String errorMsg = "Object name: " + err.getObjectName();
            log.error(errorMsg);
            errorMessages.append(errorMsg);
            if (err instanceof FieldError) {
                FieldError fieldError = (FieldError)err;
                errorMsg = "Field error: " + fieldError.getCode();
                log.error(errorMsg);
            } else {
                errorMsg = "Object error: " + err.getCode();
                log.error(errorMsg);
            }
            errorMessages.append(" ").append(errorMsg);
        }
        return Optional.of(errorMessages.toString());
    }
}

