/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.wrapper;

import com.cisco.aci.vcplugin.Constants;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.model.VcLoginSettings;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.wrapper.AciPluginWrapper;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import com.cisco.aci.vcplugin.wrapper.mockservices.MockDataService;
import com.cisco.aci.vcplugin.wrapper.mockservices.MockReferenceService;
import com.cisco.aci.vcplugin.wrapper.mockservices.MockUserSessionService;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class WrapperServiceImpl
implements WrapperService {
    private final UserSessionService _userSessionService;
    private final VimObjectReferenceService _vimObjectReferenceService;
    private final DataService _dataService;
    private final VcpLogger log = new VcpLogger();
    private AciPluginWrapper _wrapper;
    public VcLoginSettings _vcLoginSettings = new VcLoginSettings();

    public WrapperServiceImpl(String vcHost, String vcUser, String vcPassword) throws MalformedURLException, RemoteException {
        this.log.info("initializing wrapper service with mock interfaces");
        this._vcLoginSettings.setPassword(vcPassword);
        this._userSessionService = new MockUserSessionService(vcHost, vcUser, vcPassword);
        this._vimObjectReferenceService = new MockReferenceService();
        this._dataService = new MockDataService();
    }

    public WrapperServiceImpl(UserSessionService userSessionService, VimObjectReferenceService refService, DataService dataservice) {
        this.log.info("initializing wrapper service...");
        this._userSessionService = userSessionService;
        this._vimObjectReferenceService = refService;
        this._dataService = dataservice;
        this.log.info("plugin started with version: " + Constants.PLUGIN_VERSION);
    }

    @Override
    public void cleanup() {
        this.log.info("cleaning wrapper services");
    }

    @Override
    public AciPluginWrapper getWrapper() {
        if (this._wrapper == null) {
            this._wrapper = new AciPluginWrapper(this._userSessionService, this._vimObjectReferenceService, this._dataService);
        }
        return this._wrapper;
    }

    @Override
    public String getUsername() {
        try {
            return this._userSessionService.getUserSession().userName;
        }
        catch (Exception e) {
            return "__@__";
        }
    }

    @Override
    public List<Vcenter> getVCenters() {
        ServerInfo[] servers = this._userSessionService.getUserSession().serversInfo;
        ArrayList<Vcenter> vCenters = new ArrayList<Vcenter>();
        for (ServerInfo s : servers) {
            Vcenter vc = new Vcenter();
            vc.setGuid(s.serviceGuid);
            vc.setName(s.name);
            vc.setSessionCookie(s.sessionCookie);
            vc.setUrl(s.serviceUrl);
            vc.setUsername(this.getUsername());
            vc.setPassword(this._vcLoginSettings.getPassword());
            vc.setVersion(s.version);
            vCenters.add(vc);
        }
        return vCenters;
    }

    @Override
    public Vcenter getVCenterInfo(String guid) throws RuntimeException {
        for (Vcenter server : this.getVCenters()) {
            if (!guid.equals(server.getGuid())) continue;
            return server;
        }
        throw new RuntimeException("Could not find a VCenter with guid " + guid);
    }
}

