/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.api.AaaApi;
import com.cisco.aci.vcplugin.swagger.model.Certificate;
import com.cisco.aci.vcplugin.swagger.model.LoginSettings;
import com.cisco.aci.vcplugin.swagger.model.RBAC;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskOperation;
import com.cisco.aci.vcplugin.swagger.model.VcLoginSettings;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.task.RegisterFabricTask;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.TaskManager;
import com.cisco.aci.vcplugin.validators.CertificateValidator;
import com.cisco.aci.vcplugin.validators.VcpObjectValidator;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import com.cisco.apic.ApicHandle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AaaApiController
implements AaaApi {
    private final boolean DEV_MODE = false;
    private static final String PLUGIN_MODE = "vcenter";
    private final WrapperService _wrapper;
    private final HttpServletRequest _request;
    private final TaskManager _taskManager;
    private final VcpLogger log = new VcpLogger();
    private static Map<String, Map<String, ApicSdk>> _apicHandleMap = new ConcurrentHashMap<String, Map<String, ApicSdk>>();
    private static Map<String, Map<String, VCenterSdk>> _vcHandleMap = new ConcurrentHashMap<String, Map<String, VCenterSdk>>();
    private static Map<String, String> _vcPasswordMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> _vcInfoMap = new ConcurrentHashMap<String, String>();

    @Autowired
    public AaaApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper, @Qualifier(value="taskManager") TaskManager taskManager) {
        this._wrapper = wrapper;
        this._request = request;
        this._taskManager = taskManager;
    }

    @Override
    public ResponseEntity<Certificate> aaaCertGenerateGet(String name) {
        ApicHandle a = new ApicHandle();
        Certificate cert = new Certificate();
        try {
            String[] certPair = a.genCertificate(name);
            String publicKey = certPair[0];
            String privateKey = certPair[1];
            cert.setName(name);
            cert.setPublicKey(publicKey);
            cert.setPrivateKey(privateKey);
            cert.setType(Certificate.TypeEnum.SELF_SIGNED);
        }
        catch (Exception e) {
            String errMsg = "Unable to generate certificate: " + e.getMessage();
            return ResponseUtils.getErrorResponse(errMsg, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)cert);
    }

    @Override
    public ResponseEntity<Boolean> aaaCertValidatePost(@Valid @RequestBody LoginSettings settings) {
        URL url;
        Certificate cert = settings.getCertificate();
        if (!Optional.ofNullable(cert).isPresent()) {
            return ResponseUtils.getErrorResponse("Certificate not present", HttpStatus.BAD_REQUEST);
        }
        Optional<ResponseEntity> errRes = VcpObjectValidator.validateObjectRes(new CertificateValidator(false), cert, "certificate");
        if (errRes.isPresent()) {
            return errRes.get();
        }
        String hostName = settings.getUrl();
        try {
            if (hostName.startsWith("http://")) {
                return ResponseUtils.getErrorResponse("HTTP Protocol cannot be used with certificates", HttpStatus.BAD_REQUEST);
            }
            if (!hostName.startsWith("https://")) {
                hostName = "https://" + hostName;
            }
            url = new URL(hostName);
        }
        catch (MalformedURLException e) {
            return ResponseUtils.getErrorResponse("Invalid IP Address: " + hostName, HttpStatus.BAD_REQUEST);
        }
        int port = url.getPort();
        if (port == -1) {
            port = 443;
        }
        try {
            String vcUser = this._wrapper.getUsername();
            RegisterFabricTask.getHandleWithCertLogin(settings, vcUser, url, port);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            String errMsg = "Certificate authentication failed: " + e.getMessage();
            return ResponseUtils.getErrorResponse(errMsg, HttpStatus.BAD_REQUEST);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)true);
    }

    @Override
    public ResponseEntity<Task> aaaIdLogoutPost(@PathVariable(value="id") String id) {
        String username = this.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.UNREGISTER_FABRIC, id, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<RBAC> aaaIdPermissionsGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)sdk.getRBAC());
    }

    @Override
    public ResponseEntity<Task> aaaLoginPost(@Valid @RequestBody LoginSettings settings) {
        String username = this.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.REGISTER_FABRIC, settings, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<Boolean> aaaVcenterGet() {
        String user = this.getUsername();
        this.log.info("checking vc auth for user " + user);
        if (_vcHandleMap.containsKey(user)) {
            try {
                for (VCenterSdk sdk : _vcHandleMap.get(user).values()) {
                    sdk.connectVIM();
                    sdk.connectCIS();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error(e.getMessage());
                return ResponseUtils.getExceptionResponse(e);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)true);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)false);
    }

    @Override
    public ResponseEntity<Task> aaaVcenterLoginPost(@Valid @RequestBody VcLoginSettings vcLoginSettings) {
        String user = this.getUsername();
        List<Vcenter> vcList = this._wrapper.getVCenters();
        vcLoginSettings.setServers(vcList);
        ATask t = this._taskManager.newTask(TaskOperation.AUTH_VC, vcLoginSettings, user).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    public String getUsername() {
        return this._wrapper.getUsername();
    }

    public static void insertApicHandle(String username, String fabricId, ApicHandle handle, String apicUser, String apicPassword, String apicUrl, String fabricName) {
        if (!_apicHandleMap.containsKey(username)) {
            _apicHandleMap.put(username, new ConcurrentHashMap());
        }
        ApicSdk sdk = new ApicSdk(handle, fabricId, apicUser, apicPassword, apicUrl, fabricName);
        _apicHandleMap.get(username).put(fabricId, sdk);
    }

    public static void insertVCHandle(String username, String fabricId, VCenterSdk handle) {
        if (!_vcHandleMap.containsKey(username)) {
            _vcHandleMap.put(username, new ConcurrentHashMap());
        }
        _vcHandleMap.get(username).put(fabricId, handle);
    }

    public static boolean removeApicHandle(String username, String fabricId) {
        Map<String, ApicSdk> map = AaaApiController.getUserHandleMap(username);
        if (map != null && map.containsKey(fabricId)) {
            map.remove(fabricId);
            return true;
        }
        return false;
    }

    public static Map<String, ApicSdk> getUserHandleMap(String username) {
        if (_apicHandleMap.containsKey(username)) {
            return _apicHandleMap.get(username);
        }
        return null;
    }

    public static ApicSdk getApicHandle(String username, String uuid) {
        if (_apicHandleMap.containsKey(username) && _apicHandleMap.get(username).containsKey(uuid)) {
            return _apicHandleMap.get(username).get(uuid);
        }
        return null;
    }

    public static VCenterSdk getVCHandle(String username, String vcId) {
        if (_vcHandleMap.containsKey(username) && _vcHandleMap.get(username).containsKey(vcId)) {
            return _vcHandleMap.get(username).get(vcId).newHandle();
        }
        return null;
    }
}

