/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.api.ComputeApi;
import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ComputeApiController
implements ComputeApi {
    private static final Logger log = LoggerFactory.getLogger(ComputeApiController.class);
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;

    @Autowired
    public ComputeApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    @Override
    public ResponseEntity<List<EsxHost>> vcenterIdComputeHostsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="IDs of object to query") @Valid @RequestParam(value="ids", required=false) List<String> ids, @ApiParam(value="Filter based on VMM domain") @Valid @RequestParam(value="domain", required=false) String domain, @ApiParam(value="Filter based on Datacenter") @Valid @RequestParam(value="datacenter", required=false) String datacenter, @ApiParam(value="Properties to includes", allowableValues="ave, datastore") @Valid @RequestParam(value="include", required=false) List<String> include, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<EsxHost> vcentersIdComputeHostsHostOidGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="OID of the ESX", required=true) @PathVariable(value="hostOid") String hostOid, @ApiParam(value="Properties to includes", allowableValues="ave, datastore") @Valid @RequestParam(value="include", required=false) List<String> include) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", EsxHost.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

