/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.model.Apic;
import com.cisco.aci.vcplugin.swagger.model.Fabric;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="Fabric", description="the Fabric API")
public interface FabricApi {
    @ApiOperation(value="List registered Fabrics", nickname="fabricsGet", notes="", response=Fabric.class, responseContainer="List", tags={"fabric"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of registered ACI Fabric", response=Fabric.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Fabric>> fabricsGet(@ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var1);

    @ApiOperation(value="List of APICs in the Fabric", nickname="fabricsIdApicsGet", notes="", response=Apic.class, responseContainer="List", tags={"fabric"})
    @ApiResponses(value={@ApiResponse(code=200, message="List of Apic in the fabric", response=Apic.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/apics"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Apic>> fabricsIdApicsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get an ACI Fabric", nickname="fabricsIdGet", notes="", response=Fabric.class, tags={"fabric"})
    @ApiResponses(value={@ApiResponse(code=200, message="The ACI Fabric", response=Fabric.class)})
    @RequestMapping(value={"/fabrics/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Fabric> fabricsIdGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1);

    @ApiOperation(value="Refresh the existing ACI Fabric", nickname="fabricsIdRefreshGet", notes="", response=Fabric.class, tags={"fabric"})
    @ApiResponses(value={@ApiResponse(code=200, message="The currently registered ACI Fabric", response=Fabric.class)})
    @RequestMapping(value={"/fabrics/{id}/refresh"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Fabric> fabricsIdRefreshGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1);
}

