/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.model.App;
import com.cisco.aci.vcplugin.swagger.model.Bd;
import com.cisco.aci.vcplugin.swagger.model.Contract;
import com.cisco.aci.vcplugin.swagger.model.Endpoint;
import com.cisco.aci.vcplugin.swagger.model.Epg;
import com.cisco.aci.vcplugin.swagger.model.Fault;
import com.cisco.aci.vcplugin.swagger.model.Filter;
import com.cisco.aci.vcplugin.swagger.model.SystemHealth;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.Tenant;
import com.cisco.aci.vcplugin.swagger.model.Vrf;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="Tenant", description="the Tenant API")
public interface TenantApi {
    @ApiOperation(value="Get fault details for a particular object", nickname="fabricsIdFaultsGet", notes="", response=Fault.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of faults under a particular tenant", response=Fault.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/faults"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Fault>> fabricsIdFaultsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @NotNull @ApiParam(value="DN", required=true) @Valid @RequestParam(value="dn", required=true) String var2, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var3, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var4, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var5);

    @ApiOperation(value="Get list of all Application Profiles in the fabric with their fault-count and health score set.", nickname="fabricsIdHealthAppGet", notes="", response=App.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of Application Profiles in fabric with  fault-counts and health", response=App.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/health/app"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<App>> fabricsIdHealthAppGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get list of all BD in the fabric with their fault-count and health score set.", nickname="fabricsIdHealthBdGet", notes="", response=Bd.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of all BD in fabric with  fault-counts and health", response=Bd.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/health/bd"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Bd>> fabricsIdHealthBdGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get list of all contracts in the fabric with their fault-count and health score set.", nickname="fabricsIdHealthContractGet", notes="", response=Contract.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of all contracts in fabric with  fault-counts and health", response=Contract.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/health/contract"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Contract>> fabricsIdHealthContractGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get list of all EPG in the fabric with their fault-count and health score set.", nickname="fabricsIdHealthEpgGet", notes="", response=Epg.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of EPG in fabric with  fault-counts and health", response=Epg.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/health/epg"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Epg>> fabricsIdHealthEpgGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get list of all contracts in the fabric with their fault-count and health score set.", nickname="fabricsIdHealthFilterGet", notes="", response=Filter.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of all filters in fabric with  fault-counts and health", response=Filter.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/health/filter"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Filter>> fabricsIdHealthFilterGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get System health including healthscore and faults count", nickname="fabricsIdHealthSystemGet", notes="", response=SystemHealth.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="System health object containing healthscore and faults count", response=SystemHealth.class)})
    @RequestMapping(value={"/fabrics/{id}/health/system"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<SystemHealth> fabricsIdHealthSystemGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1);

    @ApiOperation(value="Get list of all VRFs in the fabric with their fault-count and health score set.", nickname="fabricsIdHealthVrfGet", notes="", response=Vrf.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of all VRFs in fabric with  fault-counts and health", response=Vrf.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/health/vrf"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Vrf>> fabricsIdHealthVrfGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get the list of tenants per fabric", nickname="fabricsIdTenantsGet", notes="", response=Tenant.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of tenants to the current fabric", response=Tenant.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/tenants"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Tenant>> fabricsIdTenantsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var3, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var4, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String var5);

    @ApiOperation(value="Delete an existing Epg", nickname="fabricsIdTenantsTenantNameAppAppNameEpgEpgNameDelete", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for deleting the Epg", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/app/{appName}/epg/{epgName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNameEpgEpgNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the Application Profile under which epg exists", required=true) @PathVariable(value="appName") String var3, @ApiParam(value="Name of the epg to be deleted", required=true) @PathVariable(value="epgName") String var4);

    @ApiOperation(value="Get list of endpoints in an EPG", nickname="fabricsIdTenantsTenantNameAppAppNameEpgEpgNameEndpointsGet", notes="", response=Endpoint.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list endpoints in an EPG", response=Endpoint.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/app/{appName}/epg/{epgName}/endpoints"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Endpoint>> fabricsIdTenantsTenantNameAppAppNameEpgEpgNameEndpointsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the Application Profile", required=true) @PathVariable(value="appName") String var3, @ApiParam(value="Name of the EPG", required=true) @PathVariable(value="epgName") String var4, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var5, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var6, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var7, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String var8);

    @ApiOperation(value="Create a new Epg", nickname="fabricsIdTenantsTenantNameAppAppNameEpgEpgNamePost", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for Epg creation", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/app/{appName}/epg/{epgName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNameEpgEpgNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the Application Profile under which epg has to be created", required=true) @PathVariable(value="appName") String var3, @ApiParam(value="Name of the epg to be created", required=true) @PathVariable(value="epgName") String var4, @ApiParam(value="The Epg to be created", required=true) @Valid @RequestBody Epg var5);

    @ApiOperation(value="Delete a BD", nickname="fabricsIdTenantsTenantNameBdBdNameDelete", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for deleting BD", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/bd/{bdName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameBdBdNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the BD to be deleted", required=true) @PathVariable(value="bdName") String var3);

    @ApiOperation(value="Create a BD under the tenant", nickname="fabricsIdTenantsTenantNameBdBdNamePost", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for BD Creation", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/bd/{bdName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameBdBdNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the BD to be created", required=true) @PathVariable(value="bdName") String var3, @ApiParam(value="The BD to be created", required=true) @Valid @RequestBody Bd var4);

    @ApiOperation(value="Get the list of BDs in a tenant of a fabric", nickname="fabricsIdTenantsTenantNameBdsGet", notes="", response=Bd.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of BDs for a tenant in a fabric", response=Bd.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/bds"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Bd>> fabricsIdTenantsTenantNameBdsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var3, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var4, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var5, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String var6, @ApiParam(value="Include objects from common Tenant", defaultValue="false") @Valid @RequestParam(value="includeCommon", required=false, defaultValue="false") Boolean var7);

    @ApiOperation(value="Delete an existing contract", nickname="fabricsIdTenantsTenantNameContractContractNameDelete", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for deleting the Contract", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/contract/{contractName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameContractContractNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the contract to be deleted", required=true) @PathVariable(value="contractName") String var3);

    @ApiOperation(value="Create a new Contract", nickname="fabricsIdTenantsTenantNameContractContractNamePost", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for Contract creation", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/contract/{contractName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameContractContractNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant for the contract", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the contract", required=true) @PathVariable(value="contractName") String var3, @ApiParam(value="The Contract to be created", required=true) @Valid @RequestBody Contract var4);

    @ApiOperation(value="Get a list of contracts under this tenant", nickname="fabricsIdTenantsTenantNameContractsGet", notes="", response=Contract.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of contracts per tenant per fabric", response=Contract.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/contracts"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Contract>> fabricsIdTenantsTenantNameContractsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var3, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var4, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var5, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String var6);

    @ApiOperation(value="Delete a tenant", nickname="fabricsIdTenantsTenantNameDelete", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for deleting Tenant", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2);

    @ApiOperation(value="Get the list of epgs per tenant per fabric", nickname="fabricsIdTenantsTenantNameEpgsGet", notes="", response=Epg.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list list of epgs per tenant per fabric", response=Epg.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/epgs"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Epg>> fabricsIdTenantsTenantNameEpgsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var3, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var4, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var5, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String var6, @ApiParam(value="Include objects from common Tenant", defaultValue="false") @Valid @RequestParam(value="includeCommon", required=false, defaultValue="false") Boolean var7);

    @ApiOperation(value="Delete a Filter", nickname="fabricsIdTenantsTenantNameFilterFilterNameDelete", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The task created for deleting Filter", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/filter/{filterName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameFilterFilterNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant under which filter is present", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the filter", required=true) @PathVariable(value="filterName") String var3);

    @ApiOperation(value="Create a Filter", nickname="fabricsIdTenantsTenantNameFilterFilterNamePost", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for Filter creation", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/filter/{filterName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameFilterFilterNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the filter", required=true) @PathVariable(value="filterName") String var3, @ApiParam(value="The Filter to be created", required=true) @Valid @RequestBody Filter var4);

    @ApiOperation(value="Get the list of Filters per tenant per fabric", nickname="fabricsIdTenantsTenantNameFiltersGet", notes="", response=Filter.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of filters per tenant per fabric", response=Filter.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/filters"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Filter>> fabricsIdTenantsTenantNameFiltersGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var3, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var4, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var5, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String var6, @ApiParam(value="Include objects from common Tenant", defaultValue="false") @Valid @RequestParam(value="includeCommon", required=false, defaultValue="false") Boolean var7);

    @ApiOperation(value="Create a new tenant in the fabric", nickname="fabricsIdTenantsTenantNamePost", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for Tenant Creation", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> fabricsIdTenantsTenantNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="The tenant to be created", required=true) @Valid @RequestBody Tenant var3);

    @ApiOperation(value="Delete a VRF", nickname="fabricsIdTenantsTenantNameVrfVrfNameDelete", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for deleting VRF", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/vrf/{vrfName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameVrfVrfNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the VRF to be delete", required=true) @PathVariable(value="vrfName") String var3);

    @ApiOperation(value="Create a new VRF", nickname="fabricsIdTenantsTenantNameVrfVrfNamePost", notes="", response=Task.class, tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for VRF Creation", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/vrf/{vrfName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameVrfVrfNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the VRF to be created", required=true) @PathVariable(value="vrfName") String var3, @ApiParam(value="The VRF to be created", required=true) @Valid @RequestBody Vrf var4);

    @ApiOperation(value="Get the list of VRFs in a tenant of a fabric", nickname="fabricsIdTenantsTenantNameVrfsGet", notes="", response=Vrf.class, responseContainer="List", tags={"tenant"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of VRFs for a tenant in a fabric", response=Vrf.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/vrfs"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Vrf>> fabricsIdTenantsTenantNameVrfsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var3, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var4, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var5, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String var6);
}

