/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.swagger.model.VcLoginSettings;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthVCTask
extends ATask {
    private final transient Log log = LogFactory.getLog(AuthVCTask.class);
    private transient VcLoginSettings _settings;
    private transient List<VCenterSdk> _SDKs;

    public AuthVCTask() {
        this.setName("VC Authorization");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("connect");
        this.addStage("save");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(VcLoginSettings.class);
        this._settings = (VcLoginSettings)this.getInput();
        if (this._settings.getPassword() == null || "".equals(this._settings.getPassword())) {
            this.failTask("The password can't be empty");
        }
        this.setProgress(10);
    }

    public void connect() throws AbortTaskException {
        this._SDKs = new ArrayList<VCenterSdk>();
        try {
            for (Vcenter s : this._settings.getServers()) {
                VCenterSdk vcSDK = new VCenterSdk(this.getInitiator(), s);
                vcSDK.setPassword(this._settings.getPassword());
                vcSDK.connectVIM();
                vcSDK.connectCIS();
                this._SDKs.add(vcSDK);
            }
        }
        catch (Exception e) {
            this.failTask(e);
        }
    }

    public void save() throws AbortTaskException {
        for (VCenterSdk sdk : this._SDKs) {
            AaaApiController.insertVCHandle(this.getInitiator(), sdk.getVcenterInfo().getGuid(), sdk);
            this.log.info((Object)("handle for vc " + sdk.getVcenterInfo().getGuid() + " has been added to the map"));
        }
    }
}

