/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.App;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;

public class CreateAppTask
extends ATask {
    private transient App _inputApp;
    private transient ApicSdk _sdk;

    public CreateAppTask() {
        this.setName("Create App");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("create");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(App.class);
        this._inputApp = (App)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputApp.getFabricId());
        this.setProgress(20);
    }

    public void create() throws AbortTaskException {
        String tenantName = this._inputApp.getParentTenant().getName();
        String appName = this._inputApp.getName();
        String appDescr = this._inputApp.getDescr();
        boolean createOnly = this._inputApp.isCreateOnly();
        try {
            this._sdk.createApp(tenantName, appName, appDescr, createOnly);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

