/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Contract;
import com.cisco.aci.vcplugin.swagger.model.Epg;
import com.cisco.aci.vcplugin.swagger.model.Filter;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;
import java.util.List;

public class CreateContractTask
extends ATask {
    private transient Contract _inputContract;
    private transient ApicSdk _sdk;

    public CreateContractTask() {
        this.setName("Create Contract");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("create");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Contract.class);
        this._inputContract = (Contract)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputContract.getFabricId());
        this.setProgress(20);
    }

    public void create() throws AbortTaskException {
        String contractName = this._inputContract.getName();
        String tenantName = this._inputContract.getParentTenant().getName();
        String description = this._inputContract.getDescr();
        List<Filter> filterList = this._inputContract.getFilters();
        List<Epg> consumerList = this._inputContract.getConsumers();
        List<Epg> providerList = this._inputContract.getProviders();
        boolean isBidirectional = this._inputContract.isIsBidirectional();
        boolean createOnly = this._inputContract.isCreateOnly();
        try {
            this._sdk.createContract(contractName, description, tenantName, filterList, consumerList, providerList, isBidirectional, createOnly);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

