/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Tenant;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;

public class CreateTenantTask
extends ATask {
    private transient Tenant _inputTenant;
    private transient ApicSdk _sdk;

    public CreateTenantTask() {
        this.setName("Create Tenant");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("create");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Tenant.class);
        this._inputTenant = (Tenant)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputTenant.getFabricId());
        this.setProgress(20);
    }

    public void create() throws AbortTaskException {
        String tenantName = this._inputTenant.getName();
        String tenantDescr = this._inputTenant.getDescr();
        boolean createOnly = this._inputTenant.isCreateOnly();
        try {
            this._sdk.createTenant(tenantName, tenantDescr, createOnly);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

