/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Tenant;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;

public class DeleteTenantTask
extends ATask {
    private transient Tenant _inputTenant;
    private transient ApicSdk _sdk;

    public DeleteTenantTask() {
        this.setName("Delete Tenant");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("delete");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Tenant.class);
        this._inputTenant = (Tenant)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputTenant.getFabricId());
        this.setProgress(20);
    }

    public void delete() throws AbortTaskException {
        String tenantName = this._inputTenant.getName();
        try {
            this._sdk.deleteTenant(tenantName);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

