/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Vrf;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;

public class DeleteVrfTask
extends ATask {
    private transient Vrf _inputVrf;
    private transient ApicSdk _sdk;

    public DeleteVrfTask() {
        this.setName("Delete VRF");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("delete");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Vrf.class);
        this._inputVrf = (Vrf)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputVrf.getFabricId());
        this.setProgress(20);
    }

    public void delete() throws AbortTaskException {
        String vrfName = this._inputVrf.getName();
        String tenantName = this._inputVrf.getParentTenant().getName();
        try {
            this._sdk.deleteVrf(vrfName, tenantName);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

