/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.Constants;
import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.storage.PersistentSettings;
import com.cisco.aci.vcplugin.swagger.model.AveVmConfig;
import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import com.cisco.aci.vcplugin.swagger.model.HostAveConfig;
import com.cisco.aci.vcplugin.swagger.model.PortGroup;
import com.cisco.aci.vcplugin.swagger.model.VmmDomain;
import com.cisco.aci.vcplugin.task.engine.AAciVToolTask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.aciPluginServices.acivtool.AciVTool;
import com.cisco.apic.util.ApicMoOperationException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewAveTask
extends AAciVToolTask {
    private HostAveConfig _taskConfig;
    private transient ApicSdk _apicHandle;
    private transient VCenterSdk _vcHandle;
    private transient VmmDomain _vmmDomain;
    private transient EsxHost _esxHost;
    private transient AveVmConfig _aveConfig;
    private transient String _infraVlan;
    private final transient Log log = LogFactory.getLog(NewAveTask.class);

    public NewAveTask() {
        this.setName("New AVE");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("infraVlan");
        this.addStage("deployAve");
    }

    public void validate() {
        try {
            this.validateInput(HostAveConfig.class);
        }
        catch (AbortTaskException e) {
            try {
                this.failTask("Failed to validate AVE deploy configuration, please check parameters set during deploy and try again");
            }
            catch (AbortTaskException excep) {
                this.log.info((Object)"NewAVE: Failed to fail new AVE task in validate");
                excep.printStackTrace();
            }
        }
        this._taskConfig = (HostAveConfig)this.getInput();
        this._aveConfig = this._taskConfig.getConfig();
        this._vmmDomain = this._taskConfig.getDomain();
        this.addEntity(this._vmmDomain);
        this._esxHost = this._taskConfig.getHost();
        this._apicHandle = AaaApiController.getApicHandle(this.getInitiator(), this._vmmDomain.getFabricId());
        this._vcHandle = AaaApiController.getVCHandle(this.getInitiator(), this._esxHost.getVcId());
        this._aveConfig.setVpodMode(this._aveConfig.isVpodMode() == null ? false : this._aveConfig.isVpodMode());
    }

    public void infraVlan() {
        try {
            this._infraVlan = this._apicHandle.getInfraVlan(this._vmmDomain.getName());
            this.log.info((Object)"NewAVE: Infra VLAN stage complete");
            this.log.info((Object)("NewAVE: Infra VLAN is " + this._infraVlan));
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.log.info((Object)"NewAVE: Failed to get infraVlan from APIC infraEpPD");
            try {
                this.failTask(e.getMessage());
            }
            catch (AbortTaskException excep) {
                this.log.info((Object)"NewAVE: Failed to fail new AVE task in infraVlan");
                excep.printStackTrace();
            }
        }
    }

    private String getMgmtPortgroup() {
        PortGroup pg = this._aveConfig.getMgmtPg();
        this.log.info((Object)("NewAVE: Management Portgroup is " + pg.toString()));
        if (pg.isDistributed().booleanValue()) {
            this.log.info((Object)"NewAVE: Management portgroup is distributed");
            return pg.getDvs().getName() + "/" + pg.getName();
        }
        this.log.info((Object)"NewAVE: Management portgroup is not distributed");
        return pg.getName();
    }

    private String getDatastore() {
        return this._aveConfig.getDatastore() != null ? this._aveConfig.getDatastore().getName() : null;
    }

    public void deployAve() throws AbortTaskException, InterruptedException {
        this.log.info((Object)"NewAVE : deploying ave");
        this.log.info((Object)"NewAVE : Create a native vCenter Task and make sure the vcplugin ATask is updating it's state based on the native VC task");
        this.startVCTask(this._vcHandle, this._esxHost, "com.cisco.aci.avs.tasks.svminstall");
        this.log.info((Object)"NewAVE : VC task started");
        try {
            AciVTool vtool = new AciVTool(PersistentSettings.getSettingsFileFolder(), Constants.JAR_PATH, Constants.PLUGIN_VERSION);
            this.log.info((Object)("Using AciVTool version : " + Constants.PLUGIN_VERSION));
            URI vcURL = new URI(this._vcHandle.getVcenterInfo().getUrl());
            vtool.setCredentialAuth(vcURL.getHost(), this._vcHandle.getUsername(), this._vcHandle.getPassword());
            this.log.info((Object)"NewAVE : Initializing vtool with parameters:");
            if (this._esxHost != null) {
                this.log.info((Object)("NewAVE: ESX host name " + this._esxHost.getName()));
            }
            if (this._vmmDomain != null) {
                this.log.info((Object)("NewAVE: Vmm domain name " + this._vmmDomain.getName()));
            }
            this.log.info((Object)("NewAVE: InfraVlan " + this._infraVlan));
            if (this._aveConfig.getClItem() != null) {
                this.log.info((Object)("NewAVE: AveConfig CLItem " + this._aveConfig.getClItem()));
                this.log.info((Object)("NewAVE: AveConfig CLItem libary" + this._aveConfig.getClItem().getLibraryName()));
            }
            this.log.info((Object)("NewAVE: ApicHandle" + this._apicHandle.toString()));
            if (this._apicHandle != null) {
                this.log.info((Object)("NewAVE: ApicVersion" + this._apicHandle.getApicVersion()));
            }
            this.log.info((Object)("NewAVE: Ave Datastore" + this.getDatastore()));
            this.log.info((Object)("NewAVE: vPOD mode" + this._aveConfig.isVpodMode()));
            this.updateProgress(2);
            vtool.AveNew(this._esxHost.getName(), this._vmmDomain.getName(), this.getMgmtPortgroup(), this._infraVlan, this._aveConfig.getClItem().getItemName(), this._apicHandle.getApicVersion(), this._aveConfig.getAdminPassword(), this._aveConfig.getClItem().getLibraryName(), this.getDatastore(), null, null, null, null, null, this._aveConfig.isVpodMode().booleanValue(), this._aveConfig.getPodId());
        }
        catch (Exception e) {
            this.log.info((Object)("NewAVE: AciVtool.AveNew error = " + e.getMessage() + e.getStackTrace()));
            e.printStackTrace();
            this.handleAciVToolException(e);
        }
    }

    @Override
    public Map<Integer, String> getProgressMessageMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(2, "Validating configuration");
        map.put(8, "Validating OVF");
        map.put(10, "Building OVF configuration");
        map.put(13, "Validating Host and Cluster");
        map.put(16, "Waiting for AVE to be the only active VM on the Host");
        map.put(20, "Deploying AVE");
        map.put(70, "Applying cluster configuration");
        map.put(75, "Applying VM configuration");
        map.put(80, "Applying VM configuration");
        map.put(90, "Applying Host configuration");
        map.put(92, "Powering on the AVE Virtual Machine");
        map.put(95, "Waiting for the AVE VM to report as healthy");
        return map;
    }
}

