/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.websocket;

import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.websocket.WsSession;
import com.cisco.aci.vcplugin.websocket.WsSessionManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;

public class VcpWebSocketEndpoint
extends Endpoint {
    private final VcpLogger log = new VcpLogger();
    private Map<String, WsSession> _sessions;
    private final WsSessionManager _wsSessionManager;
    public static VcpWebSocketEndpoint BeanInstance;

    public VcpWebSocketEndpoint(WsSessionManager wsSessionManager) {
        BeanInstance = this;
        this._sessions = new ConcurrentHashMap<String, WsSession>();
        this._wsSessionManager = wsSessionManager;
        this.log.info("intialized");
    }

    public void onOpen(Session session, EndpointConfig config) {
        WsSession s = new WsSession(session, this._wsSessionManager);
        this._sessions.put(session.getId(), s);
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        WsSession s = this._sessions.get(session.getId());
        s.onClose(closeReason);
    }

    public void onError(Session session, Throwable thr) {
        super.onError(session, thr);
        WsSession s = this._sessions.get(session.getId());
        s.onError(thr);
    }
}

