/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.wrapper;

import com.cisco.aci.vcplugin.wrapper.mockservices.MockDataService;
import com.cisco.aci.vcplugin.wrapper.mockservices.MockReferenceService;
import com.cisco.aci.vcplugin.wrapper.mockservices.MockUserSessionService;
import com.cisco.aci.vcplugin.wrapper.mockservices.MockVmwareDataService;
import com.cisco.aciPluginServices.AciPluginServices;
import com.cisco.aciPluginServices.AciPluginServicesImpl;
import com.cisco.aciPluginServices.AciPluginServicesResponse;
import com.cisco.aciPluginServices.core.AciFabricStore;
import com.cisco.aciPluginServices.core.ObjectStore;
import com.cisco.aciPluginServices.core.VmwareDataService;
import com.cisco.aciPluginServices.dataAdapter.AciDataAdapter;
import com.cisco.aciPluginServices.dataAdapter.ModelObjectUriResolver;
import com.cisco.aciPluginServices.vsphereapi.VSphereApi;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AciPluginWrapper {
    private VimObjectReferenceService _referenceService;
    private UserSessionService _userSessionService;
    private DataService _dataService;
    private ModelObjectUriResolver _uriResolver;
    private VmwareDataService _vmwareDataService;
    private VSphereApi _vsphereApi;
    private ObjectStore _objectStore;
    private AciPluginServices _aciPluginServices;
    private AciDataAdapter _dataAdapter;
    private static Log _log = LogFactory.getLog(AciPluginWrapper.class);

    public AciPluginWrapper(UserSessionService userSessionService, VimObjectReferenceService referenceService, DataService dataservice) {
        this._userSessionService = userSessionService;
        this._referenceService = referenceService;
        this._dataService = dataservice;
        this._uriResolver = new ModelObjectUriResolver();
        this._objectStore = new ObjectStore(this._uriResolver, this._userSessionService, this._dataService, this._referenceService);
        this._dataAdapter = new AciDataAdapter(this._dataService, this._uriResolver, this._referenceService, this._objectStore, this._userSessionService);
        this._vmwareDataService = new MockVmwareDataService(this._dataService, this._referenceService, this._objectStore);
        this._objectStore.setVMwareDataService(this._vmwareDataService);
        AciPluginServicesImpl services = new AciPluginServicesImpl(this._objectStore, this._uriResolver, this._userSessionService, this._referenceService);
        this._aciPluginServices = services;
        this._vsphereApi = services.getVsphereApi();
    }

    public AciPluginWrapper(String vcHost, String vcUser, String vcPassword, boolean appMode) throws MalformedURLException, RemoteException {
        this(new MockUserSessionService(vcHost, vcUser, vcPassword), new MockReferenceService(), new MockDataService());
        if (appMode) {
            AciPluginServicesImpl.PLUGIN_MODE = "app";
        }
    }

    public Object parseResponse(AciPluginServicesResponse response) throws Exception {
        if (response == null) {
            throw new Exception("Reponse is null");
        }
        if (response.errorMessage != null) {
            throw new Exception(response.errorMessage);
        }
        if (response.warningMessage != null) {
            throw new Exception(response.warningMessage);
        }
        return response.data;
    }

    public AciPluginServices getAciPluginServices() {
        return this._aciPluginServices;
    }

    public ObjectReferenceService getReferenceService() {
        return this._referenceService;
    }

    public ObjectStore getObjectStore() {
        return this._objectStore;
    }

    public VSphereApi getVsphereApi() {
        return this._vsphereApi;
    }

    public AciFabricStore getFabricStore() throws Exception {
        Map map = this._objectStore.getFabricStoresMap(this._userSessionService.getUserSession().userName);
        if (map == null || map.isEmpty()) {
            throw new Exception("There is currently no fabric registered in the plugin");
        }
        return (AciFabricStore)this._objectStore.getFabricStoresMap(this._userSessionService.getUserSession().userName).values().toArray()[0];
    }
}

