'''
Created on Oct 19, 2013

@author: feliu
'''

from translator.base.dmobject import DMObject
from utils.util import query_asa
import utils.util as util
import re

# As part of fix for CSCup19005, changes are made based on the following files in perforce:
#
# src/model/device_specification.xml#199
# src/script/translator/cluster.py#22
# test/test_cluster_simulated.py#11
# test/test_cluster.py#9

class ClusterConfig(DMObject):
    '''
    This class represents the holder of all cluster configuration.
    '''

    def __init__(self):
        DMObject.__init__(self, ClusterConfig.__name__)
        self.register_child(ClusterRole())

    @staticmethod
    def get_fault_path():
        root = util.get_config_root_key('')
        fault_path = []
        if not root:
            fault_path.append(root)
        fault_path.append((4, 'ClusterConfig', ''))
        return fault_path

    @staticmethod
    def get_cluster_check_cli(configuration):
        role = ClusterConfig.get_cluster_role(configuration)
        if role:
            return 'show cluster info'

    @staticmethod
    def get_cluster_role(configuration):
        if isinstance(configuration, dict):
            for key, val in dict(configuration).iteritems():
                if key[1] == 'cluster_role':
                    return val['value']
                else:
                    role = ClusterConfig.get_cluster_role(val['value'])
                    if role:
                        return role

    @staticmethod
    def get_health(device, configuration):
        """
        @param device: dictionary to identify the device
        @param configuration: IFC configuration parameter
        @return the health tuple for cluster, (path, integer),
                un-healthy if not able to reach the device.
        """
        cli = ClusterConfig.get_cluster_check_cli(configuration)
        if not cli:
            return None

        asa_context = device.get('asa_context')
        if asa_context and asa_context.get('system_context_accessible'):
            context_name = 'system'
        else:
            context_name = None
        response = query_asa(device, cli, context_name)[0]
        if response:
            p = re.compile('.*This is .* in state.*', re.DOTALL)
            # If device is still in cluster, then we don't return any Fault
            return ([], 100 if p.match(response) else 0)
        return ([], 0)

class ClusterRole(DMObject):
    '''
    This class represents the cluster role configuration.
    '''
    def __init__(self):
        DMObject.__init__(self, 'cluster_role')

    def populate_model(self, delta_ifc_key, delta_ifc_cfg_value):
        '''
        Populate the cluster role configuration
        '''
        self.delta_ifc_key = delta_ifc_key
        self.delta_ifc_cfg_value = delta_ifc_cfg_value
        self.state = delta_ifc_cfg_value['state']
