'''
Created on Oct 23, 2013
Copyright (c) 2013 by Cisco Systems

@author: dli
@todo replace compsitetype.py by this one, which is simpler to use, not need for SubCommand, that is one can simply use SimpleType
to  model sub-command.
'''
from simpletype import SimpleType
from dmlist import DMList
from translator.state_type import State
from translator.structured_cli import StructuredCommand
from translator.validators import Validator

class CompositeType(SimpleType):
    '''Translator for modeling ASA composite command, i.e. command with sub-commands, such as 'object network'
    '''
    def ifc2asa(self, no_asa_cfg_stack,  asa_cfg_list):
        '''Override the default implementation to take care of the sub-commands.
        '''
        if not self.has_ifc_delta_cfg():
            return

        if self.get_action() == State.DESTROY:
            'To generate the no form of the command'
            SimpleType.ifc2asa(self, no_asa_cfg_stack, asa_cfg_list)
            return

        'Generate CLIs from the children'
        child_mode_command = self.get_child_mode_command()
        for child in self.children.values():
            child.mode_command = child_mode_command
            if isinstance(child, DMList):
                for c in child.children.values():
                    c.mode_command = self.get_cli()
            child.ifc2asa(no_asa_cfg_stack, asa_cfg_list)

    def get_translator(self, cli):
        'Override the default implementation, as we do not need go down to the children'
        if self.__dict__.get('is_system_context') and self.get_top().is_user_context():
            'no audit operation if the target ASA device is user context'
            return None
        if not self.asa_key and hasattr(self, 'create_asa_key'):
            self.asa_key = self.create_asa_key()
        if self.is_my_cli(cli):
            return self
        else:
            return None


    def diff_ifc_asa(self, cli):
        'Override the default implementation to take care of the children'
        SimpleType.diff_ifc_asa(self, cli)

        if self.get_action() == State.DESTROY:
            return
        # Check to make sure that CLI is really a full structured command and not a string, when it is not incomplete like this:
        # policy-map global_policy
        #   class ips_default
        if isinstance(cli, StructuredCommand):
            for cmd in cli.sub_commands:
                translator = self.get_child_translator(cmd)
                if translator:
                    translator.diff_ifc_asa(cmd)

    def validate_configuration(self):
        'Override the default implementation to ignore children in DESTROY operation'
        if not self.has_ifc_delta_cfg():
            return

        result = []
        def report_fault(error, result):
            if isinstance(error, str):
                result.append(self.generate_fault(error))
            elif isinstance(error, tuple):
                result.append(error)
            elif isinstance(error, list):
                result.extend(error)

        if isinstance(self, Validator):
            error = self.validate(self.get_value())
            report_fault(error, result)

        if self.get_action() == State.DESTROY:
            '@todo: should this be done in the default implementation?'
            return result

        for child in self.children.values():
            child_result = child.validate_configuration()
            report_fault(child_result, result)
        return result

    def get_child_translator(self, cli):
        'Get translator for the given sub-command cli'
        for child in self.children.values():
            result = child.get_translator(cli)
            if result:
                return result
        return None

    def is_the_same_cli(self, cli):
        'Override default implementation to compare sub-commands with those of the children'
        if isinstance(cli, basestring):
            return False
        if cli.command != self.get_cli():
            return False
        'check the sub-commands, order is not important'
        sub_commands = [s.strip() for s in str(cli).split('\n')[1:]]
        return set(sub_commands) ==  set(self.get_sub_commands())

    def get_sub_commands(self):
        '@return all the sum-commands'
        result = []
        for child in self.children.values():
            if hasattr(child, 'get_cli') and child.has_ifc_delta_cfg() and child.get_cli():
                result.append(child.get_cli())
            if isinstance(child, DMList):
                result.extend([str(c.get_cli()) for c in child.children.values()])
            if isinstance(child, CompositeType):
                result.extend(child.get_sub_commands())
        return result

    def get_child_mode_command(self):
        '@return a string or tuple of strings, as the mode command(s) for the child DMObject'
        mode_command = self.get_cli()
        if not hasattr(self, 'mode_command'):
            return mode_command
        'take care of muti-level sub-command'
        if isinstance(self.mode_command, tuple):
            tmp = list(self.mode_command)
            tmp.append(mode_command)
            mode_command = tuple(tmp)
        elif self.mode_command:
            mode_command = (self.mode_command, mode_command)
        return mode_command

class Description(SimpleType):
    'Translator for description sub-command. It seems to be used in many composite commands'
    def __init__(self):
        SimpleType.__init__(self, ifc_key = 'description',
                            asa_key = 'description')

    def get_cli(self):
        'Override the default implementation to take care of the case when the field is empty'
        value = self.get_value()
        if not value:
            return self.asa_key
        else:
            return SimpleType.get_cli(self)

    def parse_cli(self, cli):
        'Override default implementation because the value is multiple words'
        if cli.strip() == self.asa_key:
            return ''
        return cli[cli.index(' ')+1:]

    def diff_ifc_asa(self, cli):
        'Take care of the case where the field is empty, which means delete operation here'
        if self.get_cli().strip() == self.asa_key and cli != self.asa_key and self.has_ifc_delta_cfg():
            del self.delta_ifc_key
            del self.delta_ifc_cfg_value
        SimpleType.diff_ifc_asa(self, cli)
