/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.dictionary.AttributeType;
import org.tinyradius.util.RadiusException;

public class IntegerAttribute
extends RadiusAttribute {
    public IntegerAttribute() {
    }

    public IntegerAttribute(int type, int value) {
        this.setAttributeType(type);
        this.setAttributeValue(value);
    }

    public int getAttributeValueInt() {
        byte[] data = this.getAttributeData();
        return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    public String getAttributeValue() {
        String name;
        int value = this.getAttributeValueInt();
        AttributeType at = this.getAttributeTypeObject();
        if (at != null && (name = at.getEnumeration(value)) != null) {
            return name;
        }
        return Integer.toString(value);
    }

    public void setAttributeValue(int value) {
        byte[] data = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        this.setAttributeData(data);
    }

    public void setAttributeValue(String value) {
        Integer val;
        AttributeType at = this.getAttributeTypeObject();
        if (at != null && (val = at.getEnumeration(value)) != null) {
            this.setAttributeValue(val);
            return;
        }
        this.setAttributeValue(Integer.parseInt(value));
    }

    public void readAttribute(byte[] data, int offset, int length) throws RadiusException {
        if (length != 6) {
            throw new RadiusException("integer attribute: expected 4 bytes data");
        }
        super.readAttribute(data, offset, length);
    }
}

