/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.packet.AccessRequest;
import org.tinyradius.packet.AccountingRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusException;
import org.tinyradius.util.ReceivedPacket;

public abstract class RadiusServer {
    private InetAddress listenAddress = null;
    private int authPort = 1812;
    private int acctPort = 1813;
    private DatagramSocket authSocket = null;
    private DatagramSocket acctSocket = null;
    private int socketTimeout = 3000;
    private List receivedPackets = new LinkedList();
    private long duplicateInterval = 30000L;
    private boolean closing = false;
    private static Log logger = LogFactory.getLog((Class)(class$org$tinyradius$util$RadiusServer == null ? (class$org$tinyradius$util$RadiusServer = RadiusServer.class$("org.tinyradius.util.RadiusServer")) : class$org$tinyradius$util$RadiusServer));
    static /* synthetic */ Class class$org$tinyradius$util$RadiusServer;

    public abstract String getSharedSecret(InetSocketAddress var1);

    public abstract String getUserPassword(String var1);

    public RadiusPacket accessRequestReceived(AccessRequest accessRequest, InetSocketAddress client) throws RadiusException {
        String plaintext = this.getUserPassword(accessRequest.getUserName());
        int type = 3;
        if (plaintext != null && accessRequest.verifyPassword(plaintext)) {
            type = 2;
        }
        RadiusPacket answer = new RadiusPacket(type, accessRequest.getPacketIdentifier());
        this.copyProxyState(accessRequest, answer);
        return answer;
    }

    public RadiusPacket accountingRequestReceived(AccountingRequest accountingRequest, InetSocketAddress client) throws RadiusException {
        RadiusPacket answer = new RadiusPacket(5, accountingRequest.getPacketIdentifier());
        this.copyProxyState(accountingRequest, answer);
        return answer;
    }

    public void start(boolean listenAuth, boolean listenAcct) {
        if (listenAuth) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    this.setName("Radius Auth Listener");
                    try {
                        logger.info((Object)("starting RadiusAuthListener on port " + RadiusServer.this.getAuthPort()));
                        RadiusServer.this.listenAuth();
                        logger.info((Object)"RadiusAuthListener is being terminated");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.fatal((Object)"auth thread stopped by exception", (Throwable)e);
                    }
                    finally {
                        RadiusServer.this.authSocket.close();
                        logger.debug((Object)"auth socket closed");
                    }
                }
            }.start();
        }
        if (listenAcct) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    this.setName("Radius Acct Listener");
                    try {
                        logger.info((Object)("starting RadiusAcctListener on port " + RadiusServer.this.getAcctPort()));
                        RadiusServer.this.listenAcct();
                        logger.info((Object)"RadiusAcctListener is being terminated");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.fatal((Object)"acct thread stopped by exception", (Throwable)e);
                    }
                    finally {
                        RadiusServer.this.acctSocket.close();
                        logger.debug((Object)"acct socket closed");
                    }
                }
            }.start();
        }
    }

    public void stop() {
        logger.info((Object)"stopping Radius server");
        this.closing = true;
        if (this.authSocket != null) {
            this.authSocket.close();
        }
        if (this.acctSocket != null) {
            this.acctSocket.close();
        }
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public void setAuthPort(int authPort) {
        if (authPort < 1 || authPort > 65535) {
            throw new IllegalArgumentException("bad port number");
        }
        this.authPort = authPort;
        this.authSocket = null;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) throws SocketException {
        if (socketTimeout < 1) {
            throw new IllegalArgumentException("socket tiemout must be positive");
        }
        this.socketTimeout = socketTimeout;
        if (this.authSocket != null) {
            this.authSocket.setSoTimeout(socketTimeout);
        }
        if (this.acctSocket != null) {
            this.acctSocket.setSoTimeout(socketTimeout);
        }
    }

    public void setAcctPort(int acctPort) {
        if (acctPort < 1 || acctPort > 65535) {
            throw new IllegalArgumentException("bad port number");
        }
        this.acctPort = acctPort;
        this.acctSocket = null;
    }

    public int getAcctPort() {
        return this.acctPort;
    }

    public long getDuplicateInterval() {
        return this.duplicateInterval;
    }

    public void setDuplicateInterval(long duplicateInterval) {
        if (duplicateInterval <= 0L) {
            throw new IllegalArgumentException("duplicate interval must be positive");
        }
        this.duplicateInterval = duplicateInterval;
    }

    public InetAddress getListenAddress() {
        return this.listenAddress;
    }

    public void setListenAddress(InetAddress listenAddress) {
        this.listenAddress = listenAddress;
    }

    protected void copyProxyState(RadiusPacket request, RadiusPacket answer) {
        List proxyStateAttrs = request.getAttributes(33);
        Iterator i = proxyStateAttrs.iterator();
        while (i.hasNext()) {
            RadiusAttribute proxyStateAttr = (RadiusAttribute)i.next();
            answer.addAttribute(proxyStateAttr);
        }
    }

    protected void listenAuth() throws SocketException {
        this.listen(this.getAuthSocket());
    }

    protected void listenAcct() throws SocketException {
        this.listen(this.getAcctSocket());
    }

    protected void listen(DatagramSocket s) {
        DatagramPacket packetIn = new DatagramPacket(new byte[4096], 4096);
        while (true) {
            try {
                while (true) {
                    block13: {
                        try {
                            logger.trace((Object)"about to call socket.receive()");
                            s.receive(packetIn);
                            if (!logger.isDebugEnabled()) break block13;
                            logger.debug((Object)("receive buffer size = " + s.getReceiveBufferSize()));
                        }
                        catch (SocketException se) {
                            if (this.closing) {
                                logger.info((Object)"got closing signal - end listen thread");
                                return;
                            }
                            logger.error((Object)"SocketException during s.receive() -> retry", (Throwable)se);
                            continue;
                        }
                    }
                    InetSocketAddress localAddress = (InetSocketAddress)s.getLocalSocketAddress();
                    InetSocketAddress remoteAddress = new InetSocketAddress(packetIn.getAddress(), packetIn.getPort());
                    String secret = this.getSharedSecret(remoteAddress);
                    if (secret == null) {
                        if (!logger.isInfoEnabled()) continue;
                        logger.info((Object)("ignoring packet from unknown client " + remoteAddress + " received on local address " + localAddress));
                        continue;
                    }
                    RadiusPacket request = this.makeRadiusPacket(packetIn, secret);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("received packet from " + remoteAddress + " on local address " + localAddress + ": " + request));
                    }
                    logger.trace((Object)"about to call RadiusServer.handlePacket()");
                    RadiusPacket response = this.handlePacket(localAddress, remoteAddress, request, secret);
                    if (response != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("send response: " + response));
                        }
                        DatagramPacket packetOut = this.makeDatagramPacket(response, secret, remoteAddress.getAddress(), packetIn.getPort(), request);
                        s.send(packetOut);
                        continue;
                    }
                    logger.info((Object)"no response sent");
                }
            }
            catch (SocketTimeoutException ste) {
                logger.trace((Object)"normal socket timeout");
                continue;
            }
            catch (IOException ioe) {
                logger.error((Object)"communication error", (Throwable)ioe);
                continue;
            }
            catch (RadiusException re) {
                logger.error((Object)"malformed Radius packet", (Throwable)re);
                continue;
            }
            break;
        }
    }

    protected RadiusPacket handlePacket(InetSocketAddress localAddress, InetSocketAddress remoteAddress, RadiusPacket request, String sharedSecret) throws RadiusException, IOException {
        RadiusPacket response = null;
        if (!this.isPacketDuplicate(request, remoteAddress)) {
            if (localAddress.getPort() == this.getAuthPort()) {
                if (request instanceof AccessRequest) {
                    response = this.accessRequestReceived((AccessRequest)request, remoteAddress);
                } else {
                    logger.error((Object)("unknown Radius packet type: " + request.getPacketType()));
                }
            } else if (localAddress.getPort() == this.getAcctPort()) {
                if (request instanceof AccountingRequest) {
                    response = this.accountingRequestReceived((AccountingRequest)request, remoteAddress);
                } else {
                    logger.error((Object)("unknown Radius packet type: " + request.getPacketType()));
                }
            }
        } else {
            logger.info((Object)"ignore duplicate packet");
        }
        return response;
    }

    protected DatagramSocket getAuthSocket() throws SocketException {
        if (this.authSocket == null) {
            this.authSocket = this.getListenAddress() == null ? new DatagramSocket(this.getAuthPort()) : new DatagramSocket(this.getAuthPort(), this.getListenAddress());
            this.authSocket.setSoTimeout(this.getSocketTimeout());
        }
        return this.authSocket;
    }

    protected DatagramSocket getAcctSocket() throws SocketException {
        if (this.acctSocket == null) {
            this.acctSocket = this.getListenAddress() == null ? new DatagramSocket(this.getAcctPort()) : new DatagramSocket(this.getAcctPort(), this.getListenAddress());
            this.acctSocket.setSoTimeout(this.getSocketTimeout());
        }
        return this.acctSocket;
    }

    protected DatagramPacket makeDatagramPacket(RadiusPacket packet, String secret, InetAddress address, int port, RadiusPacket request) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        packet.encodeResponsePacket(bos, secret, request);
        byte[] data = bos.toByteArray();
        DatagramPacket datagram = new DatagramPacket(data, data.length, address, port);
        return datagram;
    }

    protected RadiusPacket makeRadiusPacket(DatagramPacket packet, String sharedSecret) throws IOException, RadiusException {
        ByteArrayInputStream in = new ByteArrayInputStream(packet.getData());
        return RadiusPacket.decodeRequestPacket(in, sharedSecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPacketDuplicate(RadiusPacket packet, InetSocketAddress address) {
        long now = System.currentTimeMillis();
        long intervalStart = now - this.getDuplicateInterval();
        byte[] authenticator = packet.getAuthenticator();
        List list = this.receivedPackets;
        synchronized (list) {
            Iterator i = this.receivedPackets.iterator();
            while (i.hasNext()) {
                ReceivedPacket p = (ReceivedPacket)i.next();
                if (p.receiveTime < intervalStart) {
                    i.remove();
                    continue;
                }
                if (!p.address.equals(address) || p.packetIdentifier != packet.getPacketIdentifier()) continue;
                if (authenticator != null && p.authenticator != null) {
                    return Arrays.equals(p.authenticator, authenticator);
                }
                return true;
            }
            ReceivedPacket rp = new ReceivedPacket();
            rp.address = address;
            rp.packetIdentifier = packet.getPacketIdentifier();
            rp.receiveTime = now;
            rp.authenticator = authenticator;
            this.receivedPackets.add(rp);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

