/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph2;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.faceless.graph2.Axis;

public class NumericAxis
extends Axis {
    private NumberFormat m;
    private final int n;
    private boolean o;
    private boolean p;
    private static final double[] q = new double[]{0.0, 1.0, 2.0, 5.0, 5.0, 5.0, 5.0, 5.0, 10.0, 10.0, 10.0};

    static NumberFormat m() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(0);
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        numberFormat.setParseIntegerOnly(true);
        return numberFormat;
    }

    public static final NumericAxis getIntegerAxis() {
        return new NumericAxis(NumericAxis.m());
    }

    public static final NumericAxis getFloatingPointAxis() {
        return new NumericAxis(NumberFormat.getNumberInstance());
    }

    public static final NumericAxis getCurrencyAxis(Locale locale) {
        return new NumericAxis(NumberFormat.getCurrencyInstance(locale == null ? Locale.getDefault() : locale));
    }

    public NumericAxis(NumberFormat numberFormat) {
        this(numberFormat, 10);
    }

    public NumericAxis(NumberFormat numberFormat, int n2) {
        this.a(numberFormat);
        this.n = n2;
        this.o = true;
    }

    void a(NumberFormat numberFormat) {
        this.m = numberFormat;
        this.p = numberFormat == null ? false : this.format(1.0).equals(this.format(1.4));
    }

    boolean n() {
        return this.p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(double d2) {
        if (d2 == -0.0) {
            d2 = 0.0;
        }
        NumberFormat numberFormat = this.m;
        synchronized (numberFormat) {
            return this.m.format(d2);
        }
    }

    public void setStretchEnds(boolean bl) {
        this.o = bl;
    }

    public double[] steps(double d2, double d3) {
        double[] dArray;
        double d4 = this.a(d2, d3);
        if (this.p) {
            d4 = Math.ceil(d4);
        }
        if (d4 == 0.0) {
            dArray = new double[]{d2};
        } else {
            double d5 = Math.floor(d2 / d4) * d4;
            double d6 = Math.ceil(d3 / d4) * d4;
            if (!this.o) {
                if (d5 + d4 - d2 < d2 - d5) {
                    d5 += d4;
                }
                if (d3 - d6 + d4 < d6 - d3) {
                    d6 -= d4;
                }
            }
            int n2 = (int)Math.floor((d6 + d4 / 5.0 - d5) / d4);
            dArray = new double[n2 + 1];
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                dArray[i2] = d5 + d4 * (double)i2;
                if (!this.p) continue;
                dArray[i2] = Math.floor(dArray[i2]);
            }
            if (!this.o) {
                dArray[0] = d2;
                dArray[dArray.length - 1] = d3;
            }
        }
        return dArray;
    }

    private double a(double d2, double d3) {
        double d4 = Math.abs(d3 - d2);
        if (d4 == 0.0) {
            return 0.0;
        }
        d4 /= (double)this.n;
        double d5 = 1.0;
        while (d4 < 1.0) {
            d5 *= 10.0;
            d4 *= 10.0;
        }
        while (d4 > 10.0) {
            d5 /= 10.0;
            d4 /= 10.0;
        }
        d4 = Math.round(d4);
        d4 = q[(int)d4] / d5;
        return d4;
    }
}

