/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph2;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.faceless.graph2.FunctionLineSeries;
import org.faceless.util.Matrix;

public class SplineSeries
extends FunctionLineSeries {
    private final Matrix u;
    private SortedMap v;
    private double[] w;
    private double[] x;
    private double y;
    private double z;
    public static final double[][] CATMULLROM_SPLINE;
    public static final double[][] B_SPLINE;
    private static final String[] A;

    public SplineSeries(String string, double[][] dArray) {
        block4: {
            super(string);
            if (dArray != null) {
                this.u = new Matrix(dArray);
                if (this.u.getRows() != 4) {
                    throw new IllegalArgumentException(A[2]);
                }
                break block4;
            }
            this.u = null;
        }
        this.v = new TreeMap();
        this.minx = Double.POSITIVE_INFINITY;
        this.maxx = Double.NEGATIVE_INFINITY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(double d2, double d3) {
        if (this.getLineSeries() != null) {
            throw new IllegalStateException(A[0]);
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2) || Double.isNaN(d3) || Double.isInfinite(d3)) {
            throw new IllegalArgumentException(A[1]);
        }
        if (d2 != (double)((int)d2)) {
            this.setFloatingPointX();
        }
        if (d2 < this.minx) {
            this.minx = d2;
        }
        if (d2 > this.maxx) {
            this.maxx = d2;
        }
        if (d3 != (double)((int)d3) && d3 == d3) {
            this.setFloatingPointY();
        }
        this.v.put(new Double(d2), new Double(d3));
    }

    public void complete() {
        super.complete();
        if (this.getLineSeries() != null) {
            this.v = this.getLineSeries().getData();
        }
        if (this.u == null) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n2 = this.v.size();
            Iterator iterator = this.v.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                double d7 = (Double)entry.getKey();
                double d8 = (Double)entry.getValue();
                d2 += d7;
                d3 += d8;
                d4 += d7 * d7;
                d5 += d8 * d8;
                d6 += d7 * d8;
            }
            this.y = (d6 - d2 * d3 / (double)n2) / (d4 - d2 * d2 / (double)n2);
            this.z = d3 / (double)n2 - d2 / (double)n2 * this.y;
        } else {
            this.w = new double[this.v.size() + 2];
            this.x = new double[this.v.size() + 2];
            int n3 = 0;
            Iterator iterator = this.v.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.w[n3 + 1] = (Double)entry.getKey();
                this.x[n3 + 1] = (Double)entry.getValue();
                ++n3;
            }
            double[] dArray = this.w;
            int n4 = 0;
            double d9 = this.w[1];
            double[] dArray2 = this.w;
            int n5 = n3 == 1 ? 1 : 2;
            dArray[n4] = d9 - (dArray2[n5] - this.w[1]);
            double[] dArray3 = this.x;
            int n6 = 0;
            double d10 = this.x[1];
            double[] dArray4 = this.x;
            int n7 = n3 == 1 ? 1 : 2;
            dArray3[n6] = d10 - (dArray4[n7] - this.x[1]);
            double[] dArray5 = this.w;
            int n8 = this.w.length - 1;
            double d11 = this.w[this.w.length - 2];
            double d12 = this.w[this.w.length - 2];
            double[] dArray6 = this.w;
            int n9 = n3 == 1 ? 1 : this.w.length - 3;
            dArray5[n8] = d11 + (d12 - dArray6[n9]);
            double[] dArray7 = this.x;
            int n10 = this.x.length - 1;
            double d13 = this.x[this.x.length - 2];
            double d14 = this.x[this.x.length - 2];
            double[] dArray8 = this.x;
            int n11 = n3 == 1 ? 1 : this.x.length - 3;
            dArray7[n10] = d13 + (d14 - dArray8[n11]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double func(double d2) {
        if (this.u == null) {
            return d2 * this.y + this.z;
        }
        if (d2 < this.w[1] || d2 > this.w[this.w.length - this.u.getRows() + 2]) {
            return Double.NaN;
        }
        int n2 = 1;
        while (n2 < this.w.length - this.u.getRows() + 2) {
            if (d2 <= this.w[n2 + 1]) {
                return this.a(d2, n2);
            }
            ++n2;
        }
        return Double.NaN;
    }

    private double a(double d2, int n2) {
        double d3 = (d2 - this.w[n2]) / (this.w[n2 + 1] - this.w[n2]);
        Matrix matrix = new Matrix(1, this.u.getRows());
        for (int i2 = 0; i2 < this.u.getRows(); ++i2) {
            matrix.set(0, i2, Math.pow(d3, this.u.getRows() - i2 - 1));
        }
        Matrix matrix2 = new Matrix(this.u.getRows(), 2);
        for (int i3 = 0; i3 < this.u.getRows(); ++i3) {
            matrix2.set(i3, 0, this.w[i3 + n2 - 1]);
            matrix2.set(i3, 1, this.x[i3 + n2 - 1]);
        }
        Matrix matrix3 = matrix.mul(this.u).mul(matrix2);
        return matrix3.get(0, 1);
    }

    static {
        A = new String[]{SplineSeries.z(SplineSeries.z("()=cL\u0005;iv\r\u0007-'\"\n\u001e'$\" \u0005&,Q\t\u001e!,q")), SplineSeries.z(SplineSeries.z("4h(l\bL\u0011io\u0019\u001f<i`\tL:,c\u0000L&<o\u000e\t::")), SplineSeries.z(SplineSeries.z("!)=p\u0005\u0014h$w\u001f\u0018h!c\u001a\th}\"\u001e\u0003?:"))};
        CATMULLROM_SPLINE = new double[][]{{-0.5, 1.5, -1.5, 0.5}, {1.0, -2.5, 2.0, -0.5}, {-0.5, 0.0, 0.5, 0.0}, {0.0, 1.0, 0.0, 0.0}};
        B_SPLINE = new double[][]{{-0.1666666716337204, 0.5, -0.5, 0.1666666716337204}, {0.5, -1.0, 0.5, 0.0}, {-0.5, 0.0, 0.5, 0.0}, {0.1666666716337204, 0.6666666865348816, 0.1666666716337204, 0.0}};
    }

    private static char[] z(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x6C);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block9: {
            int n2;
            int n3;
            block8: {
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block8;
                n3 = n3;
                if (n3 <= n2) break block9;
            }
            do {
                int n4;
                cArray2 = cArray2;
                int n5 = n2;
                char c2 = cArray2[n5];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 108;
                        break;
                    }
                    case 1: {
                        n4 = 72;
                        break;
                    }
                    case 2: {
                        n4 = 73;
                        break;
                    }
                    case 3: {
                        n4 = 2;
                        break;
                    }
                    default: {
                        n4 = 108;
                    }
                }
                cArray2[n5] = (char)(c2 ^ n4);
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

