/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

public class Matrix {
    private int a;
    private int b;
    private double[][] c;
    private static final String[] z = new String[]{Matrix.z(Matrix.z("\u0011_cK>&\u001e`P=&W}I(r")), Matrix.z(Matrix.z("rSlQ#;F-G(r")), Matrix.z(Matrix.z("\u0011_c\u0005><Rt\u00057;Pi\u000557JhW<;PlK%rQk\u0005\u001f*p-H0&Ld]")), Matrix.z(Matrix.z("\u001cQy\u00054$[cI(rZdS8!WoI4r\\t\u00052=R~")), Matrix.z(Matrix.z("rSlQ#;F")), Matrix.z(Matrix.z("~F0")), Matrix.z(Matrix.z("\u0006LtL?5\u001eyJq5[y\u00054>[`@?&\u001et\u0018")), Matrix.z(Matrix.z("rWc\u0005")), Matrix.z(Matrix.z("\u001cQ-L?$[\u007fV4rXbWq&VdVq?_yW8*")), Matrix.z(Matrix.z("\u007fLbRq?_yW8*\u001eyJq3\u001e")), Matrix.z(Matrix.z("\u007fLbRq?_yW8*")), Matrix.z(Matrix.z("\u0011_c\u0002%r_}U4<Z-Dq")), Matrix.z(Matrix.z("\u0006LtL?5\u001eyJq![y\u00054>[`@?&\u001et\u0018")), Matrix.z(Matrix.z("\u0011_cK>&\u001elA5r")), Matrix.z(Matrix.z("\u007f]bI$?P-H0&Ld]q&Q-Dq")), Matrix.z(Matrix.z("\u007f]bI$?P-H0&Ld]")), Matrix.z(Matrix.z("r\u001e"))};

    public Matrix(int n2, int n3) {
        this.a = n2;
        this.b = n3;
        this.c = new double[n2][n3];
    }

    public Matrix(double d2, double d3, double d4, double d5, double d6, double d7) {
        this(3, 3);
        this.set(0, 0, d2);
        this.set(0, 1, d4);
        this.set(0, 2, d6);
        this.set(1, 0, d3);
        this.set(1, 1, d5);
        this.set(1, 2, d7);
        this.set(2, 2, 1.0);
    }

    public double[] getAsAffineTransform() {
        return new double[]{this.get(0, 0), this.get(1, 0), this.get(0, 1), this.get(1, 1), this.get(0, this.b - 1), this.get(1, this.b - 1)};
    }

    public Matrix(double[][] dArray) {
        this.a = dArray.length;
        this.b = dArray[0].length;
        this.c = dArray;
    }

    public Matrix(float[][] fArray) {
        this.a = fArray.length;
        this.b = fArray[0].length;
        this.c = new double[this.a][this.b];
        for (int i2 = 0; i2 < this.b; ++i2) {
            for (int i3 = 0; i3 < this.a; ++i3) {
                this.c[i3][i2] = fArray[i3][i2];
            }
            continue;
        }
    }

    public Matrix(double[] dArray, int n2) {
        int n3 = dArray.length / n2;
        if (n3 * n2 != dArray.length) {
            throw new IllegalArgumentException(z[3]);
        }
        this.a = n3;
        this.b = n2;
        this.c = new double[n3][n2];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            this.set(i2 / n2, i2 % n2, dArray[i2]);
        }
    }

    public Matrix(float[] fArray, int n2) {
        int n3 = fArray.length / n2;
        if (n3 * n2 != fArray.length) {
            throw new IllegalArgumentException(z[3]);
        }
        this.a = n3;
        this.b = n2;
        this.c = new double[n3][n2];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.set(i2 / n2, i2 % n2, fArray[i2]);
        }
    }

    public Matrix(Matrix matrix) {
        this.b = matrix.b;
        this.a = matrix.a;
        this.c = new double[this.a][this.b];
        for (int i2 = 0; i2 < this.b; ++i2) {
            for (int i3 = 0; i3 < this.a; ++i3) {
                this.set(i3, i2, matrix.get(i3, i2));
            }
            continue;
        }
    }

    public double[] getAsArray() {
        double[] dArray = new double[this.a * this.b];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = this.get(i2 / this.b, i2 % this.b);
        }
        return dArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(int n2, int n3, double d2) {
        if (n2 < this.a && n3 < this.b && n2 >= 0 && n3 >= 0) {
            this.c[n2][n3] = d2;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(z[12] + n2 + z[5] + n3 + z[7] + this.a + "x" + this.b + z[4]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double get(int n2, int n3) {
        if (n2 < this.a && n3 < this.b && n2 >= 0 && n3 >= 0) {
            return this.c[n2][n3];
        }
        throw new ArrayIndexOutOfBoundsException(z[6] + n2 + z[5] + n2 + z[7] + this.a + "x" + this.b + z[4]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.a; ++i2) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                stringBuffer.append(this.get(i2, i3) + z[16]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int getRows() {
        return this.a;
    }

    public int getCols() {
        return this.b;
    }

    public static Matrix identity(int n2) {
        Matrix matrix = new Matrix(n2, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            matrix.set(i2, i2, 1.0);
        }
        return matrix;
    }

    public Matrix exchangeRows(int n2, int n3) {
        Matrix matrix = new Matrix(this);
        for (int i2 = 0; i2 < this.b; ++i2) {
            matrix.set(n2, i2, this.get(n3, i2));
            matrix.set(n3, i2, this.get(n2, i2));
        }
        return matrix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Matrix deleteRow(int n2) {
        Matrix matrix = new Matrix(this.a - 1, this.b);
        int i2 = 0;
        while (i2 < this.a) {
            for (int n3 = 0; n3 < this.b; ++n3) {
                if (i2 < n2) {
                    matrix.set(i2, n3, this.get(i2, n3));
                    continue;
                }
                if (i2 <= n2) continue;
                matrix.set(i2 - 1, n3, this.get(i2, n3));
            }
            ++i2;
        }
        return matrix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Matrix deleteColumn(int n2) {
        Matrix matrix = new Matrix(this.a, this.b - 1);
        int i2 = 0;
        while (i2 < this.a) {
            for (int n3 = 0; n3 < this.b; ++n3) {
                if (n3 < n2) {
                    matrix.set(i2, n3, this.get(i2, n3));
                    continue;
                }
                if (n3 <= n2) continue;
                matrix.set(i2, n3 - 1, this.get(i2, n3));
            }
            ++i2;
        }
        return matrix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Matrix add(Matrix matrix) {
        if (this.b != matrix.b || this.a != matrix.a) {
            throw new IllegalArgumentException(z[13] + this.a + "x" + this.b + z[1] + matrix.a + "x" + matrix.b);
        }
        Matrix matrix2 = new Matrix(this.a, this.b);
        int i2 = 0;
        while (i2 < this.a) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                matrix2.set(i2, i3, this.get(i2, i3) + matrix.get(i2, i3));
            }
            ++i2;
        }
        return matrix2;
    }

    public Matrix mul(double d2) {
        Matrix matrix = new Matrix(this.a, this.b);
        for (int i2 = 0; i2 < this.a; ++i2) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                matrix.set(i2, i3, this.get(i2, i3) * d2);
            }
            continue;
        }
        return matrix;
    }

    public Matrix pow(double d2) {
        Matrix matrix = new Matrix(this.a, this.b);
        for (int i2 = 0; i2 < this.a; ++i2) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                matrix.set(i2, i3, Math.pow(this.get(i2, i3), d2));
            }
            continue;
        }
        return matrix;
    }

    public Matrix mul(Matrix matrix) {
        if (this.b != matrix.a) {
            throw new IllegalArgumentException(z[0] + this.a + "x" + this.b + z[1] + matrix.a + "x" + matrix.b);
        }
        Matrix matrix2 = new Matrix(this.a, matrix.b);
        for (int i2 = 0; i2 < this.a; ++i2) {
            for (int i3 = 0; i3 < matrix.b; ++i3) {
                double d2 = 0.0;
                for (int i4 = 0; i4 < this.b; ++i4) {
                    d2 += this.get(i2, i4) * matrix.get(i4, i3);
                }
                matrix2.set(i2, i3, d2);
            }
        }
        return matrix2;
    }

    public Matrix div(Matrix matrix) {
        return this.mul(matrix.inverse());
    }

    public double determinant() {
        if (this.a != this.b) {
            throw new IllegalStateException(z[2]);
        }
        if (this.a == 1) {
            return this.get(0, 0);
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.a; ++i2) {
            Matrix matrix = this.subMatrix(0, 1, this.a, this.b - 1);
            matrix = matrix.deleteRow(i2);
            d2 += Math.pow(-1.0, i2) * this.get(i2, 0) * matrix.determinant();
        }
        return d2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Matrix getRREF() {
        Matrix matrix = new Matrix(this);
        for (int i2 = 0; i2 < this.a; ++i2) {
            int n2;
            int n3;
            boolean bl = true;
            for (n3 = 0; bl && n3 < this.b; ++n3) {
                if (matrix.get(i2, n3) == 0.0) continue;
                bl = false;
            }
            if (bl) {
                if (i2 < this.a - 1) {
                    matrix = matrix.exchangeRows(i2, i2 + 1);
                    for (n3 = 0; bl && n3 < this.b; ++n3) {
                        if (matrix.get(i2, n3) == 0.0) continue;
                        bl = false;
                    }
                }
                if (bl) break;
            }
            double d2 = matrix.get(i2, i2);
            for (n2 = 0; n2 < this.b; ++n2) {
                matrix.set(i2, n2, matrix.get(i2, n2) / d2);
            }
            for (n2 = 0; n2 < this.a; ++n2) {
                if (n2 == i2) continue;
                double d3 = matrix.get(n2, i2);
                for (int i3 = 0; i3 < this.b; ++i3) {
                    matrix.set(n2, i3, matrix.get(n2, i3) - matrix.get(i2, i3) * d3);
                }
            }
        }
        matrix.clean();
        return matrix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clean() {
        int i2 = 0;
        while (i2 < this.a) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                double d2 = this.get(i2, i3);
                if (d2 == 0.0 || Math.abs(d2) < 1.0E-10 || d2 != d2) {
                    d2 = 0.0;
                }
                this.set(i2, i3, d2);
            }
            ++i2;
        }
        return;
    }

    public Matrix appendHorizontal(Matrix matrix) {
        if (matrix.a != this.a) {
            throw new IllegalArgumentException(z[11] + matrix.a + z[9] + this.a + z[10]);
        }
        Matrix matrix2 = new Matrix(this.a, this.b + matrix.b);
        for (int i2 = 0; i2 < this.a; ++i2) {
            int n2;
            for (n2 = 0; n2 < this.b; ++n2) {
                matrix2.set(i2, n2, this.get(i2, n2));
            }
            for (n2 = 0; n2 < matrix.b; ++n2) {
                matrix2.set(i2, this.b + n2, matrix.get(i2, n2));
            }
            continue;
        }
        return matrix2;
    }

    public Matrix appendVertical(Matrix matrix) {
        if (matrix.b != this.b) {
            throw new IllegalArgumentException(z[11] + matrix.b + z[14] + this.b + z[15]);
        }
        Matrix matrix2 = new Matrix(this.a + matrix.a, this.b);
        for (int i2 = 0; i2 < this.b; ++i2) {
            int n2;
            for (n2 = 0; n2 < this.a; ++n2) {
                matrix2.set(n2, i2, this.get(n2, i2));
            }
            for (n2 = 0; n2 < matrix.a; ++n2) {
                matrix2.set(this.a + n2, i2, matrix.get(n2, i2));
            }
            continue;
        }
        return matrix2;
    }

    public Matrix subMatrix(int n2, int n3, int n4, int n5) {
        Matrix matrix = new Matrix(n4, n5);
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                matrix.set(i3 - n2, i2 - n3, this.get(i3, i2));
            }
            continue;
        }
        return matrix;
    }

    public Matrix inverse() throws ArithmeticException {
        Matrix matrix = this.appendHorizontal(Matrix.identity(Math.min(this.b, this.a)));
        for (int i2 = 0; i2 < Math.min(this.a, this.b); ++i2) {
            int n2 = i2;
            while (true) {
                if (n2 >= this.a - 1 || matrix.get(n2, i2) != 0.0) break;
                matrix = matrix.exchangeRows(i2, ++n2);
            }
            if (matrix.get(i2, i2) == 0.0) {
                throw new ArithmeticException(z[8]);
            }
            matrix = matrix.pivot(i2, i2);
        }
        return matrix.subMatrix(0, this.b, this.a, this.b);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Matrix pivot(int n2, int n3) {
        int n4;
        Matrix matrix = new Matrix(this);
        for (n4 = 0; n4 < this.b; ++n4) {
            matrix.set(n2, n4, this.get(n2, n4) / this.get(n2, n3));
        }
        n4 = 0;
        while (n4 < this.a) {
            double d2 = this.get(n4, n3) / this.get(n2, n3);
            for (int n5 = 0; n5 < this.b; ++n5) {
                if (n4 == n2) continue;
                matrix.set(n4, n5, this.get(n4, n5) - this.get(n2, n5) * d2);
            }
            ++n4;
        }
        return matrix;
    }

    private static char[] z(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x51);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block9: {
            int n2;
            int n3;
            block8: {
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block8;
                n3 = n3;
                if (n3 <= n2) break block9;
            }
            do {
                int n4;
                cArray2 = cArray2;
                int n5 = n2;
                char c2 = cArray2[n5];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 82;
                        break;
                    }
                    case 1: {
                        n4 = 62;
                        break;
                    }
                    case 2: {
                        n4 = 13;
                        break;
                    }
                    case 3: {
                        n4 = 37;
                        break;
                    }
                    default: {
                        n4 = 81;
                    }
                }
                cArray2[n5] = (char)(c2 ^ n4);
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

