/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.color.ColorSpace;
import java.awt.image.RescaleOp;
import org.faceless.util.ShadablePaint;

public final class ShadablePaintFactory {
    public static ShadablePaint getInstance(Paint paint) {
        if (paint instanceof ShadablePaint) {
            return (ShadablePaint)((Object)paint);
        }
        if (paint instanceof Color) {
            return new b_((Color)paint);
        }
        if (paint instanceof GradientPaint) {
            return new c_((GradientPaint)paint);
        }
        if (paint instanceof TexturePaint) {
            return new d_((TexturePaint)paint);
        }
        return new a_(paint);
    }

    public static Color getColorAt(GradientPaint gradientPaint, double d2) {
        Color color = gradientPaint.getColor1();
        Color color2 = gradientPaint.getColor2();
        Color color3 = null;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        try {
            if (color.getColorSpace() != color2.getColorSpace()) {
                throw new Exception();
            }
            float[] fArray = color.getColorComponents(null);
            float[] fArray2 = color2.getColorComponents(null);
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                int n2 = i2;
                fArray[n2] = (float)((double)fArray[n2] + (double)(fArray2[i2] - fArray[i2]) * d2);
            }
            color3 = new Color(color.getColorSpace(), fArray, (float)((double)color.getAlpha() + (double)(color2.getAlpha() - color.getAlpha()) * d2));
        }
        catch (Throwable throwable) {
            int n3 = (int)((double)(color2.getRed() - color.getRed()) * d2);
            int n4 = (int)((double)(color2.getGreen() - color.getGreen()) * d2);
            int n5 = (int)((double)(color2.getBlue() - color.getBlue()) * d2);
            int n6 = (int)((double)(color2.getAlpha() - color.getAlpha()) * d2);
            color3 = new Color(color.getRed() + n3, color.getGreen() + n4, color.getBlue() + n5, color.getAlpha() + n6);
        }
        return color3;
    }

    private static final class a_
    implements ShadablePaint {
        private final Paint a;

        a_(Paint paint) {
            this.a = paint;
        }

        public Paint getShaded(float f2, float f3, float f4) {
            return this.a;
        }
    }

    private static class b_
    implements ShadablePaint {
        private final Color a;

        b_(Color color) {
            this.a = color;
        }

        public Paint getShaded(float f2, float f3, float f4) {
            if (f2 == 0.0f) {
                return this.a;
            }
            ColorSpace colorSpace = null;
            try {
                colorSpace = this.a.getColorSpace();
                if (colorSpace == Color.red.getColorSpace()) {
                    colorSpace = null;
                }
            }
            catch (Throwable throwable) {
                colorSpace = null;
            }
            float[] fArray = new float[3];
            int n2 = this.a.getAlpha();
            Color.RGBtoHSB(this.a.getRed(), this.a.getGreen(), this.a.getBlue(), fArray);
            fArray[2] = fArray[2] + f2;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            if (fArray[2] > f4) {
                fArray[2] = f4;
            }
            if (fArray[2] < f3) {
                fArray[2] = f3;
            }
            int n3 = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]);
            Color color = null;
            if (colorSpace != null) {
                try {
                    fArray[0] = (float)(n3 >> 16 & 0xFF) / 255.0f;
                    fArray[1] = (float)(n3 >> 8 & 0xFF) / 255.0f;
                    fArray[2] = (float)(n3 & 0xFF) / 255.0f;
                    float[] fArray2 = colorSpace.fromRGB(fArray);
                    color = new Color(colorSpace, fArray2, (float)n2 / 255.0f);
                }
                catch (Throwable throwable) {
                    colorSpace = null;
                }
            }
            if (colorSpace == null) {
                color = new Color((n3 & 0xFFFFFF) + (n2 << 24), true);
            }
            return color;
        }
    }

    private static final class c_
    implements ShadablePaint {
        private final GradientPaint a;

        c_(GradientPaint gradientPaint) {
            this.a = gradientPaint;
        }

        public Paint getShaded(float f2, float f3, float f4) {
            if (f2 == 0.0f) {
                return this.a;
            }
            Color color = (Color)new b_(this.a.getColor1()).getShaded(f2, f3, f4);
            Color color2 = (Color)new b_(this.a.getColor2()).getShaded(f2, f3, f4);
            return new GradientPaint(this.a.getPoint1(), color, this.a.getPoint2(), color2, this.a.isCyclic());
        }
    }

    private static final class d_
    implements ShadablePaint {
        private final TexturePaint a;

        d_(TexturePaint texturePaint) {
            this.a = texturePaint;
        }

        public Paint getShaded(float f2, float f3, float f4) {
            if (f2 == 0.0f) {
                return this.a;
            }
            RescaleOp rescaleOp = new RescaleOp(1.0f, f2 * 256.0f, null);
            return new TexturePaint(rescaleOp.filter(this.a.getImage(), null), this.a.getAnchorRect());
        }
    }
}

