/*
 * Decompiled with CFR 0.152.
 */
package privatecopy.com.anotherbigidea.flash.movie;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import privatecopy.com.anotherbigidea.flash.interfaces.SWFTagTypes;
import privatecopy.com.anotherbigidea.flash.movie.Actions;
import privatecopy.com.anotherbigidea.flash.movie.Instance;
import privatecopy.com.anotherbigidea.flash.movie.Movie;
import privatecopy.com.anotherbigidea.flash.movie.Placement;
import privatecopy.com.anotherbigidea.flash.movie.Sound;
import privatecopy.com.anotherbigidea.flash.movie.Symbol;
import privatecopy.com.anotherbigidea.flash.movie.TimeLine;
import privatecopy.com.anotherbigidea.flash.movie.Transform;
import privatecopy.com.anotherbigidea.flash.sound.SoundStreamHead;
import privatecopy.com.anotherbigidea.flash.structs.AlphaTransform;
import privatecopy.com.anotherbigidea.flash.structs.SoundInfo;

public class Frame {
    protected int frameNumber;
    protected String label;
    protected Vector placements = new Vector();
    protected boolean stop;
    protected TimeLine timeline;
    protected Actions actions;
    protected SoundStreamHead soundHeader;
    protected byte[] soundData;
    protected Sound soundToStart;
    protected int customTag = -1;
    protected byte[] customTagData;
    protected boolean mAnchor;

    protected Frame(int n2, TimeLine timeLine) {
        this.frameNumber = n2;
        this.timeline = timeLine;
    }

    public SoundStreamHead getSoundHeader() {
        return this.soundHeader;
    }

    public void setSoundHeader(SoundStreamHead soundStreamHead) {
        this.soundHeader = soundStreamHead;
    }

    public byte[] getSoundData() {
        return this.soundData;
    }

    public void setSoundData(byte[] byArray) {
        this.soundData = byArray;
    }

    public boolean isAnchor() {
        return this.mAnchor;
    }

    public void setAnchor(boolean bl) {
        this.mAnchor = bl;
    }

    public void setCustomTag(int n2, byte[] byArray) {
        this.customTag = n2;
        this.customTagData = byArray;
    }

    public int startSound(Sound sound, int n2) {
        this.soundToStart = sound;
        int n3 = sound.getFrequency();
        switch (n3) {
            case 0: {
                n3 = 5500;
                break;
            }
            case 1: {
                n3 = 11000;
                break;
            }
            case 2: {
                n3 = 22000;
                break;
            }
            case 3: {
                n3 = 44000;
                break;
            }
            default: {
                n3 = 22000;
            }
        }
        int n4 = sound.getSampleCount();
        int n5 = n4 / n3;
        return n5 * n2;
    }

    public Actions getActions() {
        return this.actions;
    }

    public void setActions(Actions actions) {
        this.actions = actions;
    }

    public Actions actions(int n2) {
        this.actions = new Actions(0, n2);
        return this.actions;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public Placement[] getPlacements() {
        Object[] objectArray = new Placement[this.placements.size()];
        this.placements.copyInto(objectArray);
        return objectArray;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void stop() {
        this.stop = true;
    }

    public Instance placeSymbol(Symbol symbol, int n2, int n3) {
        return this.placeSymbol(symbol, new Transform(n2, n3), null, -1, -1);
    }

    public Instance placeSymbol(Symbol symbol, Transform transform, AlphaTransform alphaTransform) {
        return this.placeSymbol(symbol, transform, alphaTransform, -1, -1);
    }

    public Instance placeSymbol(Symbol symbol, Transform transform, AlphaTransform alphaTransform, int n2, int n3) {
        int n4 = this.timeline.getAvailableDepth();
        Instance instance = new Instance(symbol, n4);
        this.timeline.setAvailableDepth(n4 + 1);
        if (transform == null) {
            transform = new Transform();
        }
        Placement placement = new Placement(instance, transform, alphaTransform, null, n2, n3, this.frameNumber, false, false, null);
        this.placements.add(placement);
        return instance;
    }

    public Instance replaceSymbol(Symbol symbol, int n2, Transform transform, AlphaTransform alphaTransform, int n3, int n4) {
        Instance instance = new Instance(symbol, n2);
        if (transform == null) {
            transform = new Transform();
        }
        Placement placement = new Placement(instance, transform, alphaTransform, null, n3, n4, this.frameNumber, false, true, null);
        this.placements.add(placement);
        return instance;
    }

    public void undefineSymbol(Symbol symbol) {
        this.placements.add(new Placement(symbol));
    }

    public Instance placeMovieClip(Symbol symbol, Transform transform, AlphaTransform alphaTransform, String string, Actions[] actionsArray) {
        int n2 = this.timeline.getAvailableDepth();
        Instance instance = new Instance(symbol, n2);
        this.timeline.setAvailableDepth(n2 + 1);
        if (transform == null) {
            transform = new Transform();
        }
        Placement placement = new Placement(instance, transform, alphaTransform, string, -1, -1, this.frameNumber, false, false, actionsArray);
        this.placements.add(placement);
        return instance;
    }

    public Instance replaceMovieClip(Symbol symbol, int n2, Transform transform, AlphaTransform alphaTransform, String string, Actions[] actionsArray) {
        Instance instance = new Instance(symbol, n2);
        if (transform == null) {
            transform = new Transform();
        }
        Placement placement = new Placement(instance, transform, alphaTransform, string, -1, -1, this.frameNumber, false, true, actionsArray);
        this.placements.add(placement);
        return instance;
    }

    public void remove(Instance instance) {
        this.placements.add(new Placement(instance, this.frameNumber));
    }

    public void alter(Instance instance, int n2, int n3) {
        this.alter(instance, new Transform(n2, n3), null, -1);
    }

    public void alter(Instance instance, Transform transform, AlphaTransform alphaTransform) {
        this.alter(instance, transform, alphaTransform, -1);
    }

    public void alter(Instance instance, Transform transform, AlphaTransform alphaTransform, int n2) {
        Placement placement = new Placement(instance, transform, alphaTransform, null, n2, -1, this.frameNumber, true, false, null);
        this.placements.add(placement);
    }

    protected void flushDefinitions(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
        Enumeration enumeration = this.placements.elements();
        while (enumeration.hasMoreElements()) {
            Placement placement = (Placement)enumeration.nextElement();
            placement.flushDefinitions(movie, sWFTagTypes, sWFTagTypes2);
        }
    }

    protected void write(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
        Object object;
        if (this.customTag >= 0) {
            sWFTagTypes2.tag(this.customTag, false, this.customTagData);
        }
        if (this.actions != null) {
            object = sWFTagTypes2.tagDoAction();
            object.start(0);
            object.blob(this.actions.bytes);
            object.done();
        }
        if (this.stop) {
            object = sWFTagTypes2.tagDoAction();
            object.start(0);
            object.stop();
            object.end();
            object.done();
        }
        if (this.soundHeader != null) {
            this.soundHeader.write(sWFTagTypes2);
        }
        if (this.soundData != null) {
            sWFTagTypes2.tagSoundStreamBlock(this.soundData);
        }
        if (this.soundToStart != null) {
            sWFTagTypes2.tagStartSound(this.soundToStart.define(movie, sWFTagTypes, sWFTagTypes2), new SoundInfo(true, false, null, -1, -1, 0));
        }
        object = this.placements.elements();
        while (object.hasMoreElements()) {
            Placement placement = (Placement)object.nextElement();
            placement.write(movie, sWFTagTypes, sWFTagTypes2);
        }
        if (this.label != null) {
            sWFTagTypes2.tagFrameLabel(this.label, this.mAnchor);
        }
        sWFTagTypes2.tagShowFrame();
    }
}

