/*
 * Decompiled with CFR 0.152.
 */
package privatecopy.com.anotherbigidea.flash.movie;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import privatecopy.com.anotherbigidea.flash.interfaces.SWFTagTypes;
import privatecopy.com.anotherbigidea.flash.movie.ExportedSymbol;
import privatecopy.com.anotherbigidea.flash.movie.Frame;
import privatecopy.com.anotherbigidea.flash.movie.ImportedSymbol;
import privatecopy.com.anotherbigidea.flash.movie.Symbol;
import privatecopy.com.anotherbigidea.flash.movie.TimeLine;
import privatecopy.com.anotherbigidea.flash.structs.Color;
import privatecopy.com.anotherbigidea.flash.writers.SWFWriter;
import privatecopy.com.anotherbigidea.flash.writers.TagWriter;

public class Movie
implements TimeLine {
    protected int width;
    protected int height;
    protected int frameRate;
    protected Color backColor;
    protected int version;
    protected boolean isProtected;
    protected Map importLibraries;
    protected Vector exportedSymbols;
    protected SortedMap frames = new TreeMap();
    protected int frameCount = 0;
    protected HashMap definedSymbols = new HashMap();
    protected int depth = 1;
    protected int maxId = 1;

    public Movie() {
        this.width = 550;
        this.height = 400;
        this.frameRate = 12;
        this.version = 5;
    }

    public Movie(int n2, int n3, int n4, int n5, Color color) {
        this.width = n2;
        this.height = n3;
        this.frameRate = n4;
        this.version = n5;
        this.backColor = color;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public int getVersion() {
        return this.version;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public void setFrameRate(int n2) {
        this.frameRate = n2;
    }

    public void setVersion(int n2) {
        this.version = n2;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void protect(boolean bl) {
        this.isProtected = bl;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public Frame getFrame(int n2) {
        if (n2 < 1) {
            return null;
        }
        Integer n3 = new Integer(n2);
        Frame frame = (Frame)this.frames.get(n3);
        if (frame == null) {
            frame = new Frame(n2, this);
            this.frames.put(n3, frame);
            if (n2 > this.frameCount) {
                this.frameCount = n2;
            }
        }
        return frame;
    }

    public Frame appendFrame() {
        ++this.frameCount;
        Frame frame = new Frame(this.frameCount, this);
        this.frames.put(new Integer(this.frameCount), frame);
        return frame;
    }

    public int getAvailableDepth() {
        return this.depth;
    }

    public void setAvailableDepth(int n2) {
        if (n2 < 1) {
            return;
        }
        this.depth = n2;
    }

    public ImportedSymbol[] importSymbols(String string, String[] stringArray) {
        ArrayList<ImportedSymbol> arrayList;
        if (this.importLibraries == null) {
            this.importLibraries = new HashMap();
        }
        if ((arrayList = (ArrayList<ImportedSymbol>)this.importLibraries.get(string)) == null) {
            arrayList = new ArrayList<ImportedSymbol>();
            this.importLibraries.put(string, arrayList);
        }
        ImportedSymbol[] importedSymbolArray = new ImportedSymbol[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            ImportedSymbol importedSymbol;
            importedSymbolArray[i2] = importedSymbol = new ImportedSymbol(0, stringArray[i2], string);
            arrayList.add(importedSymbol);
        }
        return importedSymbolArray;
    }

    public void clearImports() {
        if (this.importLibraries != null) {
            this.importLibraries.clear();
        }
    }

    public ImportedSymbol[] getImportedSymbols() {
        if (this.importLibraries == null) {
            return new ImportedSymbol[0];
        }
        Vector vector = new Vector();
        Object[] objectArray = this.importLibraries.values().iterator();
        while (objectArray.hasNext()) {
            List list = (List)objectArray.next();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
        }
        objectArray = new ImportedSymbol[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void exportSymbols(String[] stringArray, Symbol[] symbolArray) {
        if (this.exportedSymbols == null) {
            this.exportedSymbols = new Vector();
        }
        for (int i2 = 0; i2 < stringArray.length && i2 < symbolArray.length; ++i2) {
            this.exportedSymbols.add(new ExportedSymbol(symbolArray[i2], stringArray[i2]));
        }
    }

    public ExportedSymbol[] getExportedSymbols() {
        if (this.exportedSymbols == null) {
            return new ExportedSymbol[0];
        }
        Object[] objectArray = new ExportedSymbol[this.exportedSymbols.size()];
        this.exportedSymbols.copyInto(objectArray);
        return objectArray;
    }

    public void clearExports() {
        if (this.exportedSymbols != null) {
            this.exportedSymbols.clear();
        }
    }

    public void write(SWFTagTypes sWFTagTypes) throws IOException {
        Object object;
        block18: {
            Object object2;
            String[] stringArray;
            String[] stringArray2;
            block17: {
                this.definedSymbols.clear();
                this.maxId = 1;
                sWFTagTypes.header(this.version, -1L, this.width * 20, this.height * 20, this.frameRate, -1);
                if (this.backColor == null) {
                    this.backColor = new Color(255, 255, 255);
                }
                sWFTagTypes.tagSetBackgroundColor(this.backColor);
                if (this.isProtected) {
                    sWFTagTypes.tagProtect(null);
                }
                if (this.importLibraries == null || this.importLibraries.isEmpty()) break block17;
                stringArray2 = this.importLibraries.keySet().iterator();
                while (stringArray2.hasNext()) {
                    object = (String)stringArray2.next();
                    List list = (List)this.importLibraries.get(object);
                    stringArray = new String[list.size()];
                    object2 = new int[list.size()];
                    int n2 = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ImportedSymbol importedSymbol = (ImportedSymbol)iterator.next();
                        stringArray[n2] = importedSymbol.getName();
                        object2[n2] = importedSymbol.define(this, sWFTagTypes, sWFTagTypes);
                        ++n2;
                    }
                    sWFTagTypes.tagImport((String)object, stringArray, (int[])object2);
                }
            }
            if (this.exportedSymbols == null || this.exportedSymbols.isEmpty()) break block18;
            stringArray2 = new String[this.exportedSymbols.size()];
            object = new int[this.exportedSymbols.size()];
            int n3 = 0;
            stringArray = this.exportedSymbols.iterator();
            while (stringArray.hasNext()) {
                object2 = (ExportedSymbol)stringArray.next();
                stringArray2[n3] = ((ExportedSymbol)object2).getExportName();
                object[n3] = ((ExportedSymbol)object2).getSymbol().define(this, sWFTagTypes, sWFTagTypes);
                ++n3;
            }
            sWFTagTypes.tagExport(stringArray2, (int[])object);
        }
        int n4 = 0;
        object = this.frames.values().iterator();
        while (object.hasNext()) {
            Frame frame = (Frame)object.next();
            int n5 = frame.getFrameNumber();
            while (n5 > n4 + 1) {
                sWFTagTypes.tagShowFrame();
                ++n4;
            }
            frame.write(this, sWFTagTypes, sWFTagTypes);
            n4 = n5;
        }
        sWFTagTypes.tagEnd();
    }

    public void write(String string) throws IOException {
        this.write(string, false);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, false);
    }

    public void write(String string, boolean bl) throws IOException {
        SWFWriter sWFWriter = new SWFWriter(string);
        TagWriter tagWriter = new TagWriter(sWFWriter);
        sWFWriter.setCompression(bl);
        this.write(tagWriter);
    }

    public void write(OutputStream outputStream, boolean bl) throws IOException {
        SWFWriter sWFWriter = new SWFWriter(outputStream);
        TagWriter tagWriter = new TagWriter(sWFWriter);
        sWFWriter.setCompression(bl);
        this.write(tagWriter);
    }
}

