/*
 * Decompiled with CFR 0.152.
 */
package privatecopy.com.anotherbigidea.flash.structs;

import java.io.IOException;
import privatecopy.com.anotherbigidea.flash.structs.Color;
import privatecopy.com.anotherbigidea.flash.structs.Matrix;
import privatecopy.com.anotherbigidea.flash.structs.Style;
import privatecopy.com.anotherbigidea.io.OutStream;

public class FillStyle
implements Style {
    protected int fillType;
    protected Color color;
    protected Matrix matrix;
    protected int[] ratios;
    protected Color[] colors;
    protected int bitmapId;

    public int getType() {
        return this.fillType;
    }

    public Color getSolidColor() {
        return this.color;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public int getImageId() {
        return this.bitmapId;
    }

    public int[] getGradientRatios() {
        return this.ratios;
    }

    public Color[] getGradientColors() {
        return this.colors;
    }

    public FillStyle(Color color) {
        this.fillType = 0;
        this.color = color;
    }

    public FillStyle(Matrix matrix, int[] nArray, Color[] colorArray, boolean bl) {
        this.matrix = matrix;
        this.ratios = nArray;
        this.colors = colorArray;
        this.fillType = bl ? 18 : 16;
    }

    public FillStyle(int n2, Matrix matrix, boolean bl) {
        this.matrix = matrix;
        this.bitmapId = n2;
        this.fillType = bl ? 65 : 64;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(OutStream outStream, boolean bl) throws IOException {
        outStream.writeUI8(this.fillType);
        if (this.fillType == 0) {
            if (bl) {
                this.color.writeWithAlpha(outStream);
                return;
            }
            this.color.writeRGB(outStream);
            return;
        }
        if (this.fillType != 16 && this.fillType != 18) {
            if (this.fillType != 64) {
                if (this.fillType != 65) return;
            }
            outStream.writeUI16(this.bitmapId);
            this.matrix.write(outStream);
            return;
        }
        this.matrix.write(outStream);
        int n2 = this.ratios.length;
        outStream.writeUI8(n2);
        int n3 = 0;
        while (n3 < n2) {
            if (this.colors[n3] != null) {
                outStream.writeUI8(this.ratios[n3]);
                if (bl) {
                    this.colors[n3].writeWithAlpha(outStream);
                } else {
                    this.colors[n3].writeRGB(outStream);
                }
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeMorphFillStyle(OutStream outStream, FillStyle fillStyle, FillStyle fillStyle2) throws IOException {
        int n2 = fillStyle.fillType;
        outStream.writeUI8(n2);
        if (n2 == 0) {
            fillStyle.color.writeWithAlpha(outStream);
            fillStyle2.color.writeWithAlpha(outStream);
            return;
        }
        if (n2 != 16 && n2 != 18) {
            if (n2 != 64) {
                if (n2 != 65) return;
            }
            int n5 = fillStyle.bitmapId;
            outStream.writeUI16(n5);
            fillStyle.matrix.write(outStream);
            fillStyle2.matrix.write(outStream);
            return;
        }
        fillStyle.matrix.write(outStream);
        fillStyle2.matrix.write(outStream);
        int n3 = fillStyle.ratios.length;
        outStream.writeUI8(fillStyle.ratios.length);
        int n4 = 0;
        while (n4 < n3) {
            if (fillStyle.colors[n4] != null && fillStyle2.colors[n4] != null) {
                outStream.writeUI8(fillStyle.ratios[n4]);
                fillStyle.colors[n4].writeWithAlpha(outStream);
                outStream.writeUI8(fillStyle2.ratios[n4]);
                fillStyle2.colors[n4].writeWithAlpha(outStream);
            }
            ++n4;
        }
    }
}

