/*
 * Decompiled with CFR 0.152.
 */
package privatecopy.com.anotherbigidea.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import privatecopy.com.anotherbigidea.io.OutputStreamWrapper;

public class OutStream
extends OutputStreamWrapper {
    private int b;
    private int c;

    public OutStream(OutputStream outputStream) {
        super(outputStream);
        this.a();
    }

    protected OutStream() {
        super(null);
    }

    public void writeSBits(int n2, int n3) throws IOException {
        long l2 = n3 & Integer.MAX_VALUE;
        if (n3 < 0) {
            l2 |= 1L << n2 - 1;
        }
        this.writeUBits(n2, l2);
    }

    public void flush() throws IOException {
        this.flushBits();
        super.flush();
    }

    public void writeCompressed() {
        this.setOutputStream(new DeflaterOutputStream(this.getOutputStream(), new Deflater(9)));
    }

    public void flushBits() throws IOException {
        if (this.c == 0) {
            return;
        }
        super.write(this.b);
        this.b = 0;
        this.c = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeUBits(int n2, long l2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.c == 0) {
            this.c = 8;
        }
        int n3 = n2;
        while (n3 > 0) {
            while (this.c > 0 && n3 > 0) {
                if (OutStream.getBit(n3, l2)) {
                    this.b = OutStream.setBit(this.c, this.b);
                }
                --n3;
                --this.c;
            }
            if (this.c != 0) continue;
            this.writeUI8(this.b);
            this.b = 0;
            if (n3 <= 0) continue;
            this.c = 8;
        }
        return;
    }

    public static boolean getBit(int n2, long l2) {
        return (l2 & 1L << n2 - 1) != 0L;
    }

    public static int setBit(int n2, int n3) {
        return n3 | 1 << n2 - 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] byArray) throws IOException {
        this.flushBits();
        if (byArray == null) return;
        if (byArray.length <= 0) return;
        super.write(byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.flushBits();
        if (byArray == null) return;
        if (n3 <= 0) return;
        super.write(byArray, n2, n3);
    }

    public void writeUI8(int n2) throws IOException {
        this.flushBits();
        super.write(n2);
    }

    public void writeUI16(int n2) throws IOException {
        this.flushBits();
        super.write(n2 & 0xFF);
        super.write(n2 >> 8);
    }

    public void writeSI16(short s2) throws IOException {
        this.flushBits();
        super.write(s2 & 0xFF);
        super.write(s2 >> 8);
    }

    public void writeUI32(long l2) throws IOException {
        this.flushBits();
        super.write((int)(l2 & 0xFFL));
        super.write((int)(l2 >> 8));
        super.write((int)(l2 >> 16));
        super.write((int)(l2 >> 24));
    }

    public void writeString(String string, String string2) throws IOException {
        if (string == null) {
            string = "";
        }
        this.writeString(string.getBytes(string2));
    }

    public void writeString(byte[] byArray) throws IOException {
        this.flushBits();
        if (byArray != null) {
            super.write(byArray);
        }
        super.write(0);
    }

    public static int getStringLength(byte[] byArray) {
        if (byArray == null) {
            return 1;
        }
        return byArray.length + 1;
    }

    public static int getStringLength(String string) {
        if (string == null) {
            return 1;
        }
        byte[] byArray = string.getBytes();
        return byArray.length + 1;
    }

    private void a() {
        this.b = 0;
        this.c = 0;
    }

    public static int determineSignedBitSize(int n2) {
        int n3;
        if (n2 >= 0) {
            return OutStream.determineUnsignedBitSize(n2) + 1;
        }
        long l2 = 0x40000000L;
        for (n3 = 31; n3 > 0 && ((long)n2 & l2) != 0L; --n3) {
            l2 >>= 1;
        }
        if (n3 == 0) {
            return 2;
        }
        int n4 = n2 & (1 << n3) - 1;
        if (n4 == 0) {
            ++n3;
        }
        return n3 + 1;
    }

    public static int determineUnsignedBitSize(long l2) {
        long l3 = 0x80000000L;
        for (int i2 = 32; i2 > 0; --i2) {
            if ((l2 & l3) != 0L) {
                return i2;
            }
            l3 >>= 1;
        }
        return 0;
    }

    public void writeFloat(float f2) throws IOException {
        this.writeSI32(Float.floatToIntBits(f2));
    }

    public void writeDouble(double d2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeDouble(d2);
        dataOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = new byte[]{byArray[3], byArray[2], byArray[1], byArray[0], byArray[7], byArray[6], byArray[5], byArray[4]};
        this.write(byArray2);
    }

    public void writeSI32(int n2) throws IOException {
        this.flushBits();
        super.write(n2 & 0xFF);
        super.write(n2 >> 8);
        super.write(n2 >> 16);
        super.write(n2 >> 24);
    }

    public static byte[] sintTo2Bytes(int n2) {
        return new byte[]{OutStream.uintToByte(n2 & 0xFF), OutStream.uintToByte(n2 >> 8)};
    }

    public static byte[] uintTo2Bytes(int n2) {
        return new byte[]{OutStream.uintToByte(n2 & 0xFF), OutStream.uintToByte(n2 >> 8)};
    }

    public static byte[] uintTo4Bytes(int n2) {
        return new byte[]{OutStream.uintToByte(n2 & 0xFF), OutStream.uintToByte(n2 >> 8), OutStream.uintToByte(n2 >> 16), OutStream.uintToByte(n2 >> 24)};
    }

    public static byte uintToByte(int n2) {
        int n3 = n2 & 1;
        byte by = (byte)(n2 >>= 1);
        by = (byte)(by << 1);
        by = (byte)(by | (byte)n3);
        return by;
    }

    public void write(int n2) throws IOException {
        this.flushBits();
        super.write(n2);
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

