/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class ConcurrentStateTransferTest
extends ChannelTestBase {
    private final AtomicInteger mod = new AtomicInteger(1);

    public void setUp() throws Exception {
        super.setUp();
        this.mod.set(1);
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    public boolean useBlocking() {
        return true;
    }

    public void testConcurrentLargeStateTransfer() {
        this.concurrentStateTranferHelper(true, false);
    }

    public void testConcurrentSmallStateTranfer() {
        this.concurrentStateTranferHelper(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concurrentStateTranferHelper(boolean largeState, boolean useDispatcher) {
        String[] names = new String[]{"A", "B", "C", "D"};
        int count = names.length;
        ChannelTestBase.ChannelRetrievable[] channels = new ConcurrentStateTransfer[count];
        Semaphore semaphore = new Semaphore(count);
        try {
            semaphore.acquire(count);
            for (int i = 0; i < count; ++i) {
                channels[i] = largeState ? new ConcurrentLargeStateTransfer(names[i], semaphore, useDispatcher) : new ConcurrentStateTransfer(names[i], semaphore, useDispatcher);
                ((ChannelTestBase.ChannelApplication)channels[i]).start();
                Util.sleep(500L);
            }
            ConcurrentStateTransferTest.blockUntilViewsReceived(channels, 60000L);
            Util.sleep(1000L);
            semaphore.release(count);
            Util.sleep(1000L);
            boolean acquired = semaphore.tryAcquire(count, 30L, TimeUnit.SECONDS);
            if (!acquired) {
                this.log.warn((Object)"Most likely a bug, analyse the stack below:");
                this.log.warn((Object)Util.dumpThreads());
            }
            Util.sleep(2000L);
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                this.log.info((Object)(((ChannelTestBase.ChannelApplication)channel).getName() + "=" + ((ConcurrentStateTransfer)channel).getList()));
            }
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                this.log.info((Object)(((ChannelTestBase.ChannelApplication)channel).getName() + "=" + ((ConcurrentStateTransfer)channel).getModifications()));
            }
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                ConcurrentStateTransferTest.assertEquals((String)(((ChannelTestBase.ChannelApplication)channel).getName() + " should have " + count + " elements"), (int)count, (int)((ConcurrentStateTransfer)channel).getList().size());
            }
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                ConcurrentStateTransferTest.checkEventStateTransferSequence((ChannelTestBase.EventSequence)((Object)channel));
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)"Exception encountered during test", (Throwable)ex);
            ConcurrentStateTransferTest.fail((String)ex.getLocalizedMessage());
        }
        finally {
            for (int i = count - 1; i >= 0; --i) {
                ((ChannelTestBase.ChannelApplication)channels[i]).cleanup();
                Util.sleep(250L);
            }
        }
    }

    protected int getMod() {
        return this.mod.incrementAndGet();
    }

    public static Test suite() {
        return new TestSuite(ConcurrentStateTransferTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConcurrentStateTransferTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    protected class ConcurrentLargeStateTransfer
    extends ConcurrentStateTransfer {
        private static final long TRANSFER_TIME = 2500L;

        public ConcurrentLargeStateTransfer(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
        }

        public void setState(byte[] state) {
            Util.sleep(2500L);
            super.setState(state);
        }

        public byte[] getState() {
            Util.sleep(2500L);
            return super.getState();
        }

        public void getState(OutputStream ostream) {
            Util.sleep(2500L);
            super.getState(ostream);
        }

        public void setState(InputStream istream) {
            Util.sleep(2500L);
            super.setState(istream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConcurrentStateTransfer
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        private final List<Address> l;
        Channel ch;
        private final Map<Integer, Object> mods;

        public ConcurrentStateTransfer(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
            this.l = new LinkedList<Address>();
            this.mods = new TreeMap<Integer, Object>();
            this.channel.connect("test");
        }

        @Override
        public void useChannel() throws Exception {
            boolean success = this.channel.getState(null, 30000L);
            ConcurrentStateTransferTest.this.log.info((Object)("channel.getState at " + this.getName() + this.getLocalAddress() + " returned " + success));
            this.channel.send(null, null, this.channel.getLocalAddress());
        }

        List<Address> getList() {
            return this.l;
        }

        Map<Integer, Object> getModifications() {
            return this.mods;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            if (msg.getBuffer() == null) {
                return;
            }
            Address obj = (Address)msg.getObject();
            ConcurrentStateTransferTest.this.log.info((Object)("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: received " + obj));
            ConcurrentStateTransfer concurrentStateTransfer = this;
            synchronized (concurrentStateTransfer) {
                this.l.add(obj);
                Integer key = new Integer(ConcurrentStateTransferTest.this.getMod());
                this.mods.put(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void viewAccepted(View new_view) {
            super.viewAccepted(new_view);
            ConcurrentStateTransfer concurrentStateTransfer = this;
            synchronized (concurrentStateTransfer) {
                Integer key = new Integer(ConcurrentStateTransferTest.this.getMod());
                this.mods.put(key, new_view.getVid());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(byte[] state) {
            super.setState(state);
            try {
                List tmp = (List)Util.objectFromByteBuffer(state);
                ConcurrentStateTransfer concurrentStateTransfer = this;
                synchronized (concurrentStateTransfer) {
                    this.l.clear();
                    this.l.addAll(tmp);
                    ConcurrentStateTransferTest.this.log.info((Object)("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: state is " + this.l));
                    Integer key = new Integer(ConcurrentStateTransferTest.this.getMod());
                    this.mods.put(key, tmp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getState() {
            super.getState();
            LinkedList<Address> tmp = null;
            ConcurrentStateTransfer concurrentStateTransfer = this;
            synchronized (concurrentStateTransfer) {
                tmp = new LinkedList<Address>(this.l);
                try {
                    return Util.objectToByteBuffer(tmp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getState(OutputStream ostream) {
            super.getState(ostream);
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                LinkedList<Address> tmp = null;
                ConcurrentStateTransfer concurrentStateTransfer = this;
                synchronized (concurrentStateTransfer) {
                    tmp = new LinkedList<Address>(this.l);
                }
                oos.writeObject(tmp);
                oos.flush();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Util.close(oos);
                    throw throwable;
                }
                Util.close(oos);
            }
            Util.close(oos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(InputStream istream) {
            super.setState(istream);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(istream);
                List tmp = (List)ois.readObject();
                ConcurrentStateTransfer concurrentStateTransfer = this;
                synchronized (concurrentStateTransfer) {
                    this.l.clear();
                    this.l.addAll(tmp);
                    ConcurrentStateTransferTest.this.log.info((Object)("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: state is " + this.l));
                    Integer key = new Integer(ConcurrentStateTransferTest.this.getMod());
                    this.mods.put(key, tmp);
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Util.close(ois);
                    throw throwable;
                }
                Util.close(ois);
            }
            Util.close(ois);
        }
    }
}

