/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf;

import java.util.Collection;
import java.util.Iterator;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class DelegatingPhaseListenerMulticaster
implements PhaseListener {
    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        Collection listeners = this.getDelegates(event.getFacesContext());
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            PhaseListener listener = (PhaseListener)it.next();
            listener.beforePhase(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        Collection listeners = this.getDelegates(event.getFacesContext());
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            PhaseListener listener = (PhaseListener)it.next();
            listener.afterPhase(event);
        }
    }

    protected Collection getDelegates(FacesContext facesContext) {
        ListableBeanFactory bf = this.getBeanFactory(facesContext);
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(bf, PhaseListener.class, true, false).values();
    }

    protected ListableBeanFactory getBeanFactory(FacesContext facesContext) {
        return this.getWebApplicationContext(facesContext);
    }

    protected WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        return FacesContextUtils.getRequiredWebApplicationContext(facesContext);
    }
}

