/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.api;

import com.pcube.management.UMVersion;
import com.pcube.management.api.common.BaseApi;
import com.pcube.management.common.time.BasicTimestampController;
import com.pcube.management.common.time.Timestamp;
import com.pcube.management.framework.rpc.Client;
import com.pcube.management.framework.rpc.DisconnectListener;
import com.pcube.management.framework.rpc.OperationTimeoutException;
import com.pcube.management.framework.rpc.RpcErrorException;
import java.util.Properties;

public class SMBlockingApi {
    private static final String[] SIG_LOGIN = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.SHORT_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_CLASS_NAME, "boolean", "int"};
    private static final String[] SIG_LOGOUT = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.SHORT_ARRAY_CLASS_NAME};
    private static final String[] SIG_LOGOUT_FROM_DOMAIN = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.SHORT_ARRAY_CLASS_NAME, BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_LOGOUT_BY_MAPPING = new String[]{BaseApi.STRING_CLASS_NAME, "short", BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_CABLE_LOGIN = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME, "int", BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME};
    private static final String[] SIG_CABLE_LOGOUT = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_ADD_SUBSCRIBER = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.SHORT_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_REMOVE_SUBSCRIBER = new String[]{BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_GET_NUM_OF_SUBSCRIBERS = new String[]{BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_GET_FORMATTED_SUBSCRIBER = new String[]{BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_SUBSCRIBER_EXISTS = new String[]{BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_SUBSCRIBER_LOGGED_IN = new String[]{BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_GET_SUBSCRIBER_NAME_BY_MAPPING = new String[]{BaseApi.STRING_CLASS_NAME, "short", BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_GET_SUBSCRIBER_NAMES_IN_RANGE = new String[]{BaseApi.STRING_CLASS_NAME, "int"};
    private static final String[] SIG_GET_SUBSCRIBER_NAMES_IN_DOMAIN = new String[]{BaseApi.STRING_CLASS_NAME, "int", BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_GET_SUBSCRIBER_NAMES_WITH_PREFIX = new String[]{BaseApi.STRING_CLASS_NAME, "int", BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_GET_SUBSCRIBER_NAMES_WITH_SUFFIX = new String[]{BaseApi.STRING_CLASS_NAME, "int", BaseApi.STRING_CLASS_NAME};
    private static final String[] ARG_GET_DOMAINS = new String[]{"Type", "Subscriber"};
    private static final String[] SIG_GET_DOMAINS = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_RESET_PROPERTIES = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME};
    private static final String[] SIG_REMOVE_CUSTOM_PROPERTIES = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME};
    private Client client;
    private long timeout = 0L;

    public String toString() {
        return super.toString();
    }

    public SMBlockingApi() {
        this(null);
    }

    public SMBlockingApi(String string) {
        String string2 = System.getProperty("com.pcube.management.isAgent");
        if (string2 == null || string2.compareToIgnoreCase("false") == 0) {
            Timestamp.setController(new BasicTimestampController(5000L, false));
        }
        this.client = new Client("BER", string == null ? SMBlockingApi.generateNameSuffix() : string + '.' + SMBlockingApi.generateNameSuffix(), 1);
    }

    public void init(Properties properties) {
        this.client.init(properties);
    }

    public void connect(String string) throws Exception {
        this.client.connect(string);
    }

    public void connect(String string, int n) throws Exception {
        this.client.connect(string, n);
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public boolean isConnected() {
        return !this.client.isClosed();
    }

    public String getClientVersion() {
        return UMVersion.getVersion();
    }

    public String getSMVersion() {
        return this.client.getServerVersion();
    }

    public void setDisconnectListener(DisconnectListener disconnectListener) {
        this.client.setDisconnectListener(disconnectListener);
    }

    public final void setReplyTimeout(long l) {
        this.timeout = l;
    }

    public void login(String string, String[] stringArray, short[] sArray, String[] stringArray2, String[] stringArray3, String string2, boolean bl, int n) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        this.client.invokeAndWait("SMM:name=SMM", "login", new Object[]{string, stringArray, sArray, stringArray2, stringArray3, string2, bl ? Boolean.TRUE : Boolean.FALSE, new Integer(n)}, SIG_LOGIN, this.timeout);
    }

    public boolean logoutByName(String string, String[] stringArray, short[] sArray) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "logout", new Object[]{string, stringArray, sArray}, SIG_LOGOUT, this.timeout);
        return (Boolean)object;
    }

    public boolean logoutByNameFromDomain(String string, String[] stringArray, short[] sArray, String string2) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "logoutFromDomain", new Object[]{string, stringArray, sArray, string2}, SIG_LOGOUT_FROM_DOMAIN, this.timeout);
        return (Boolean)object;
    }

    public boolean logoutByMapping(String string, short s, String string2) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "logoutByMapping", new Object[]{string, new Short(s), string2}, SIG_LOGOUT_BY_MAPPING, this.timeout);
        return (Boolean)object;
    }

    public void loginCable(String string, String string2, String string3, int n, String string4, String[] stringArray, String[] stringArray2) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        this.client.invokeAndWait("SMM:name=CableAdaptor", "login", new Object[]{string, string2, string3, new Integer(n), string4, stringArray, stringArray2}, SIG_CABLE_LOGIN, this.timeout);
    }

    public boolean logoutCable(String string, String string2, String string3, String string4) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=CableAdaptor", "logout", new Object[]{string, string2, string3, string4}, SIG_CABLE_LOGOUT, this.timeout);
        return (Boolean)object;
    }

    public void addSubscriber(String string, String[] stringArray, short[] sArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String string2) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        this.client.invokeAndWait("SMM:name=SMM", "addSubscriber", new Object[]{string, stringArray, sArray, stringArray2, stringArray3, stringArray4, stringArray5, string2}, SIG_ADD_SUBSCRIBER, this.timeout);
    }

    public boolean removeSubscriber(String string) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "removeSubscriber", new Object[]{string}, SIG_REMOVE_SUBSCRIBER, this.timeout);
        return (Boolean)object;
    }

    public void removeAllSubscribers() throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        this.client.invokeAndWait("SMM:name=SMM", "removeAllSubscribers", BaseApi.EMPTY_OBJECT_ARRAY, BaseApi.EMPTY_STRING_ARRAY, this.timeout);
    }

    public int getNumberOfSubscribers() throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "getNumOfSubscribers", BaseApi.EMPTY_OBJECT_ARRAY, BaseApi.EMPTY_STRING_ARRAY, this.timeout);
        return (Integer)object;
    }

    public int getNumberOfSubscribersInDomain(String string) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "getNumOfSubscribers", new Object[]{string}, SIG_GET_NUM_OF_SUBSCRIBERS, this.timeout);
        return (Integer)object;
    }

    public Object[] getSubscriber(String string) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        return (Object[])this.client.invokeAndWait("SMM:name=SMM", "getFormattedSubscriber", new Object[]{string}, SIG_GET_FORMATTED_SUBSCRIBER, this.timeout);
    }

    public boolean subscriberExists(String string) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "subscriberExists", new Object[]{string}, SIG_SUBSCRIBER_EXISTS, this.timeout);
        return (Boolean)object;
    }

    public boolean subscriberLoggedIn(String string) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "subscriberLoggedIn", new Object[]{string}, SIG_SUBSCRIBER_LOGGED_IN, this.timeout);
        return (Boolean)object;
    }

    public String getSubscriberNameByMapping(String string, short s, String string2) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "getSubscriberNameByMapping", new Object[]{string, new Short(s), string2}, SIG_GET_SUBSCRIBER_NAME_BY_MAPPING, this.timeout);
        return object == null ? null : (String)object;
    }

    public String[] getSubscriberNames(String string, int n) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "getSubscriberNamesInRange", new Object[]{string, new Integer(n)}, SIG_GET_SUBSCRIBER_NAMES_IN_RANGE, this.timeout);
        return (String[])object;
    }

    public String[] getSubscriberNamesInDomain(String string, int n, String string2) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "getSubscriberNamesInDomain", new Object[]{string, new Integer(n), string2}, SIG_GET_SUBSCRIBER_NAMES_IN_DOMAIN, this.timeout);
        return (String[])object;
    }

    public String[] getSubscriberNamesWithPrefix(String string, int n, String string2) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "getSubscriberNamesWithPrefix", new Object[]{string, new Integer(n), string2}, SIG_GET_SUBSCRIBER_NAMES_WITH_PREFIX, this.timeout);
        return (String[])object;
    }

    public String[] getSubscriberNamesWithSuffix(String string, int n, String string2) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("SMM:name=SMM", "getSubscriberNamesWithSuffix", new Object[]{string, new Integer(n), string2}, SIG_GET_SUBSCRIBER_NAMES_WITH_SUFFIX, this.timeout);
        return (String[])object;
    }

    public String[] getDomains() throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        Object object = this.client.invokeAndWait("EMS:name=DomainManager", "getDomainsWhichContainProperty", ARG_GET_DOMAINS, SIG_GET_DOMAINS, this.timeout);
        return (String[])object;
    }

    public void setPropertiesToDefault(String string, String[] stringArray) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        this.client.invokeAndWait("SMM:name=SMM", "resetProperties", new Object[]{string, stringArray}, SIG_RESET_PROPERTIES, this.timeout);
    }

    public void removeCustomProperties(String string, String[] stringArray) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        this.verifyConnection();
        this.client.invokeAndWait("SMM:name=SMM", "removeCustomProperties", new Object[]{string, stringArray}, SIG_REMOVE_CUSTOM_PROPERTIES, this.timeout);
    }

    private static final String generateNameSuffix() {
        return "B.SM-API.J";
    }

    private final void verifyConnection() throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("The api is not connected");
        }
    }
}

