/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.api;

import com.pcube.management.UMVersion;
import com.pcube.management.api.common.BaseApi;
import com.pcube.management.common.time.BasicTimestampController;
import com.pcube.management.common.time.Timestamp;
import com.pcube.management.framework.rpc.Client;
import com.pcube.management.framework.rpc.DisconnectListener;
import com.pcube.management.framework.rpc.ResultHandler;
import java.util.Properties;

public class SMNonBlockingApi {
    private static final int WAIT_TIMEOUT = 100;
    static final long RECONNECT_THREAD_DEATH_JOIN_TIMEOUT = 10000L;
    public static final long DEFAULT_TIMEOUT = 45000L;
    private Client client;
    private long autoReconnectPeriod;
    private ReconnectThread reconnectThread = null;
    private boolean running = false;
    private ApiDisconnectListener disconnectListener;
    private boolean reliable = true;
    private String hostname = null;
    private int port = 14374;
    private boolean disconnectRequested = false;
    private static final String[] SIG_LOGIN = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.SHORT_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_CLASS_NAME, "boolean", "int"};
    private static final String[] SIG_LOGOUT = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.SHORT_ARRAY_CLASS_NAME};
    private static final String[] SIG_LOGOUT_FROM_DOMAIN = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.SHORT_ARRAY_CLASS_NAME, BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_LOGOUT_BY_MAPPING = new String[]{BaseApi.STRING_CLASS_NAME, "short", BaseApi.STRING_CLASS_NAME};
    private static final String[] SIG_CABLE_LOGIN = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME, "int", BaseApi.STRING_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME, BaseApi.STRING_ARRAY_CLASS_NAME};
    private static final String[] SIG_CABLE_LOGOUT = new String[]{BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME, BaseApi.STRING_CLASS_NAME};

    public String toString() {
        return super.toString();
    }

    public SMNonBlockingApi() {
        this(null, true, -1L);
    }

    public SMNonBlockingApi(long l) {
        this(null, true, l);
    }

    public SMNonBlockingApi(boolean bl, long l) {
        this(null, bl, l);
    }

    public SMNonBlockingApi(String string, boolean bl, long l) {
        this.reliable = bl;
        this.autoReconnectPeriod = l;
        String string2 = System.getProperty("com.pcube.management.isAgent");
        if (string2 == null || string2.compareToIgnoreCase("false") == 0) {
            Timestamp.setController(new BasicTimestampController(5000L, false));
        }
        String string3 = string == null || string.length() == 0 ? SMNonBlockingApi.generateNameSuffix() : string + '.' + SMNonBlockingApi.generateNameSuffix();
        this.client = new Client("BER", string3, 2, this.reliable);
        this.disconnectListener = new ApiDisconnectListener();
        this.client.setDisconnectListener(this.disconnectListener);
    }

    public SMNonBlockingApi(String string) {
        this(string, true, -1L);
    }

    public SMNonBlockingApi(String string, long l) {
        this(string, true, l);
    }

    public void init(Properties properties) {
        this.client.init(properties);
    }

    public void connect(String string) throws Exception {
        this.connect(string, 14374);
    }

    public void connect(String string, int n) throws Exception {
        this.hostname = string;
        this.port = n;
        try {
            this.disconnectRequested = false;
            this.client.connect(string, n);
        }
        catch (Exception exception) {
            if (this.autoReconnectPeriod > 0L) {
                this.startReconnectingThread();
            }
            throw exception;
        }
    }

    public void disconnect() {
        this.makeSureReconnectThreadIsDead();
        this.disconnectRequested = true;
        this.client.disconnect();
    }

    public boolean isConnected() {
        return !this.client.isClosed();
    }

    public String getClientVersion() {
        return UMVersion.getVersion();
    }

    public String getSMVersion() {
        return this.client.getServerVersion();
    }

    public void setDisconnectListener(DisconnectListener disconnectListener) {
        this.disconnectListener.setDisconnectListener(disconnectListener);
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.client.setResultHandler(resultHandler);
    }

    public long login(String string, String[] stringArray, short[] sArray, String[] stringArray2, String[] stringArray3, String string2, boolean bl, int n) throws InterruptedException {
        this.verifyConnection();
        return this.client.invoke("SMM:name=SMM", "login", new Object[]{string, stringArray, sArray, stringArray2, stringArray3, string2, bl ? Boolean.TRUE : Boolean.FALSE, new Integer(n)}, SIG_LOGIN);
    }

    public long logoutByName(String string, String[] stringArray, short[] sArray) throws InterruptedException {
        this.verifyConnection();
        return this.client.invoke("SMM:name=SMM", "logout", new Object[]{string, stringArray, sArray}, SIG_LOGOUT);
    }

    public long logoutByNameFromDomain(String string, String[] stringArray, short[] sArray, String string2) throws InterruptedException {
        this.verifyConnection();
        return this.client.invoke("SMM:name=SMM", "logoutFromDomain", new Object[]{string, stringArray, sArray, string2}, SIG_LOGOUT_FROM_DOMAIN);
    }

    public long logoutByMapping(String string, short s, String string2) throws InterruptedException {
        this.verifyConnection();
        return this.client.invoke("SMM:name=SMM", "logoutByMapping", new Object[]{string, new Short(s), string2}, SIG_LOGOUT_BY_MAPPING);
    }

    public long loginCable(String string, String string2, String string3, int n, String string4, String[] stringArray, String[] stringArray2) throws InterruptedException {
        this.verifyConnection();
        return this.client.invoke("SMM:name=CableAdaptor", "login", new Object[]{string, string2, string3, new Integer(n), string4, stringArray, stringArray2}, SIG_CABLE_LOGIN);
    }

    public long logoutCable(String string, String string2, String string3, String string4) throws InterruptedException {
        this.verifyConnection();
        return this.client.invoke("SMM:name=CableAdaptor", "logout", new Object[]{string, string2, string3, string4}, SIG_CABLE_LOGOUT);
    }

    private static final String generateNameSuffix() {
        return "NB.SM-API.J";
    }

    private final void verifyConnection() throws IllegalStateException {
        if (!this.reliable && !this.isConnected()) {
            throw new IllegalStateException("The api is not connected");
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.stopReconnectingThread();
    }

    private final void startReconnectingThread() {
        this.makeSureReconnectThreadIsDead();
        this.running = true;
        this.reconnectThread = new ReconnectThread();
        this.reconnectThread.start();
    }

    public void stopReconnectingThread() {
        this.running = false;
        this.makeSureReconnectThreadIsDead();
    }

    private final void makeSureReconnectThreadIsDead() {
        if (this.reconnectThread != null && this.reconnectThread.isAlive()) {
            this.reconnectThread.requestStop();
            long l = System.currentTimeMillis();
            do {
                try {
                    this.reconnectThread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.reconnectThread.isAlive() && System.currentTimeMillis() - l < 10000L);
            if (this.reconnectThread.isAlive()) {
                System.out.println("Could not wait for dying reconnect thread.");
            }
            this.reconnectThread = null;
        }
    }

    private class ApiDisconnectListener
    implements DisconnectListener {
        DisconnectListener userDisconnectListener = null;

        private ApiDisconnectListener() {
        }

        public String toString() {
            return super.toString();
        }

        public void connectionIsDown() {
            if (this.userDisconnectListener != null) {
                this.userDisconnectListener.connectionIsDown();
            }
            if (SMNonBlockingApi.this.autoReconnectPeriod > 0L && !SMNonBlockingApi.this.disconnectRequested) {
                SMNonBlockingApi.this.startReconnectingThread();
            }
        }

        public final void setDisconnectListener(DisconnectListener disconnectListener) {
            this.userDisconnectListener = disconnectListener;
        }
    }

    private class ReconnectThread
    extends Thread {
        private ReconnectThread() {
        }

        public String toString() {
            return super.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!SMNonBlockingApi.this.isConnected() && SMNonBlockingApi.this.running) {
                try {
                    ReconnectThread reconnectThread = this;
                    synchronized (reconnectThread) {
                        SMNonBlockingApi.this.client.connect(SMNonBlockingApi.this.hostname, SMNonBlockingApi.this.port);
                    }
                    return;
                }
                catch (Exception exception) {
                    if (SMNonBlockingApi.this.isConnected() || !SMNonBlockingApi.this.running) continue;
                    try {
                        ReconnectThread.sleep(SMNonBlockingApi.this.autoReconnectPeriod);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public synchronized void requestStop() {
            SMNonBlockingApi.this.running = false;
            this.interrupt();
        }
    }
}

