/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.SparseArray;
import com.pcube.management.common.StringComparator;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class ArrayUtilities {
    static final Comparator STRING_COMPARATOR = new StringComparator();

    public static String[] stringToArray(String string, boolean bl, String string2) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = bl ? stringTokenizer.nextToken().toLowerCase() : stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static Throwable[] getThrowablesFromObjectArray(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Throwable) {
                arrayList.add(objectArray[i]);
                continue;
            }
            if (!(objectArray[i] instanceof Object[])) continue;
            Throwable[] throwableArray = ArrayUtilities.getThrowablesFromObjectArray((Object[])objectArray[i]);
            for (int j = 0; j < throwableArray.length; ++j) {
                arrayList.add(throwableArray[j]);
            }
        }
        return arrayList.toArray(new Throwable[0]);
    }

    public static String stringArrayToString(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1 || string == null) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void applyChangedIndices(SparseArray sparseArray, SparseArray sparseArray2) {
        if (!ArrayUtilities.compare(sparseArray.getDimensions(), sparseArray2.getDimensions())) {
            throw new IllegalArgumentException("A and B have different number of entries");
        }
        if (!sparseArray.get(0).getClass().equals(sparseArray2.get(0).getClass())) {
            throw new IllegalArgumentException("A and B are of different value classes");
        }
        int n = sparseArray.getLastFlatIndex();
        for (int i = 0; i < n; ++i) {
            Object object = sparseArray.get(i);
            if (object.equals(sparseArray2.get(i))) continue;
            sparseArray2.set(i, object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] stringToArray(String string) {
        if (string == null) {
            return new String[0];
        }
        int n = 0;
        StringReader stringReader = new StringReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        try {
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype != 34) {
                    if (streamTokenizer.ttype != -3) {
                        if (streamTokenizer.ttype != -2) continue;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringReader = new StringReader(string);
        streamTokenizer = new StreamTokenizer(stringReader);
        String[] stringArray = new String[n];
        n = 0;
        try {
            while (streamTokenizer.nextToken() != -1) {
                block13: {
                    block12: {
                        if (streamTokenizer.ttype == 34) break block12;
                        if (streamTokenizer.ttype != -3) break block13;
                    }
                    stringArray[n++] = streamTokenizer.sval;
                    continue;
                }
                if (streamTokenizer.ttype != -2) continue;
                stringArray[n++] = "" + streamTokenizer.nval;
            }
            return stringArray;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public static void sort(String[] stringArray) {
        Arrays.sort(stringArray, STRING_COMPARATOR);
    }

    public static int[] stringToIntArray(String string) throws IllegalArgumentException {
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,-", true);
            Vector<Integer> vector = new Vector<Integer>();
            String string2 = null;
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals(" ") || string2.equals(",")) continue;
                if (string2.equals("-")) {
                    bl = true;
                    continue;
                }
                int n2 = Integer.parseInt(string2);
                if (bl) {
                    n = (Integer)vector.get(vector.size() - 1) + 1;
                    int n3 = n2;
                    for (int i = n; i <= n3; ++i) {
                        vector.add(new Integer(i));
                    }
                    bl = false;
                    continue;
                }
                vector.add(new Integer(n2));
            }
            int[] nArray = new int[vector.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)vector.get(n);
            }
            return nArray;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid string: " + string + " : " + exception);
        }
    }

    public static Object[] arrayToStrings(Object object) {
        Object[] objectArray = new Object[Array.getLength(object)];
        for (int i = 0; i < Array.getLength(object); ++i) {
            if (Array.get(object, i) == null) continue;
            Object object2 = Array.get(object, i);
            objectArray[i] = object2.getClass().isArray() ? ArrayUtilities.arrayToStrings(object2) : object2.toString();
        }
        return objectArray;
    }

    public static String[] objectArrayToStringArray(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i] != null ? objectArray[i].toString() : null;
        }
        return stringArray;
    }

    public static boolean compare(Object object, Object object2) {
        if (object != null && object2 != null) {
            if (object.getClass() != object2.getClass()) {
                return false;
            }
            if (object instanceof byte[]) {
                return Arrays.equals((byte[])object, (byte[])object2);
            }
            if (object instanceof char[]) {
                return Arrays.equals((char[])object, (char[])object2);
            }
            if (object instanceof short[]) {
                return Arrays.equals((short[])object, (short[])object2);
            }
            if (object instanceof int[]) {
                return Arrays.equals((int[])object, (int[])object2);
            }
            if (object instanceof long[]) {
                return Arrays.equals((long[])object, (long[])object2);
            }
            if (object instanceof float[]) {
                return Arrays.equals((float[])object, (float[])object2);
            }
            if (object instanceof double[]) {
                return Arrays.equals((double[])object, (double[])object2);
            }
            if (object instanceof boolean[]) {
                return Arrays.equals((boolean[])object, (boolean[])object2);
            }
            if (object instanceof Hashtable) {
                Hashtable hashtable = (Hashtable)object;
                Hashtable hashtable2 = (Hashtable)object2;
                if (hashtable.size() == hashtable2.size()) {
                    Enumeration enumeration = hashtable.keys();
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        if (hashtable2.containsKey(k)) {
                            Object v;
                            Object v2 = hashtable.get(k);
                            if (!ArrayUtilities.compare(v2, v = hashtable2.get(k))) {
                                return false;
                            }
                            ++n;
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                if (objectArray.length != objectArray2.length) {
                    return false;
                }
                if (objectArray.length == 0) {
                    return true;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    if (ArrayUtilities.compare(objectArray[i], objectArray2[i])) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                Map map2 = (Map)object2;
                if (map.size() == map2.size()) {
                    Iterator iterator = map.keySet().iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        if (map2.containsKey(k)) {
                            Object v;
                            Object v3 = map.get(k);
                            if (!ArrayUtilities.compare(v3, v = map2.get(k))) {
                                return false;
                            }
                            ++n;
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return object.equals(object2);
        }
        return object == null && object2 == null;
    }

    public static Object[] purifyArray(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        Class<?> clazz = objectArray2.getClass().getComponentType();
        if (objectArray2.length < n) {
            objectArray2 = (Object[])Array.newInstance(clazz, n);
        }
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = objectArray[i] != null && clazz.isAssignableFrom(objectArray[i].getClass()) ? objectArray[i] : null;
        }
        if (objectArray2.length > n) {
            Arrays.fill(objectArray2, n, objectArray2.length - 1, null);
        }
        return objectArray2;
    }

    public static void printObject(PrintStream printStream, Object object, String string) {
        ArrayUtilities.printObject(new PrintWriter(printStream, true), object, string, new HashMap());
    }

    public static void printObject(PrintWriter printWriter, Object object, String string) {
        ArrayUtilities.printObject(printWriter, object, string, new HashMap());
    }

    protected static void printObject(PrintWriter printWriter, Object object, String string, HashMap hashMap) {
        printWriter.print(string + " = " + object);
        if (object != null) {
            printWriter.print(" is " + object.getClass());
            if (object.getClass().isArray() && hashMap.containsKey(object)) {
                printWriter.println(" cycle detected");
            }
        }
        printWriter.println();
        if (object != null && object.getClass().isArray() && !hashMap.containsKey(object)) {
            hashMap.put(object, null);
            for (int i = 0; i < Array.getLength(object); ++i) {
                ArrayUtilities.printObject(printWriter, Array.get(object, i), "  " + string + "[" + i + "]", hashMap);
            }
        }
    }

    public static Object mergeArrays(Object object, Object object2) throws IllegalArgumentException {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException("Arguments can't be null");
        }
        if (object.getClass().equals(object2.getClass()) && object.getClass().isArray()) {
            try {
                int n;
                int n2 = Array.getLength(object);
                int n3 = Array.getLength(object2);
                int n4 = n2 + n3;
                Object object3 = Array.newInstance(object.getClass().getComponentType(), n4);
                for (n = 0; n < n2; ++n) {
                    Array.set(object3, n, Array.get(object, n));
                }
                int n5 = 0;
                for (n = n2; n < n4; ++n) {
                    Array.set(object3, n, Array.get(object2, n5));
                    ++n5;
                }
                return object3;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new RuntimeException("Unexpected exception " + throwable);
            }
        }
        throw new IllegalArgumentException("Arrays must be of same instance");
    }

    public static int[] mergeArrays(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null || nArray.length == 0) {
            return nArray2;
        }
        if (nArray2 == null || nArray2.length == 0) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = nArray[n];
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray3[nArray.length + n] = nArray2[n];
        }
        return nArray3;
    }

    public static long[] mergeArrays(long[] lArray, long[] lArray2) {
        int n;
        if (lArray == null || lArray.length == 0) {
            return lArray2;
        }
        if (lArray2 == null || lArray2.length == 0) {
            return lArray;
        }
        long[] lArray3 = new long[lArray.length + lArray2.length];
        for (n = 0; n < lArray.length; ++n) {
            lArray3[n] = lArray[n];
        }
        for (n = 0; n < lArray2.length; ++n) {
            lArray3[lArray.length + n] = lArray2[n];
        }
        return lArray3;
    }

    public static String[] mergeArrays(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return stringArray2;
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[stringArray.length + n] = stringArray2[n];
        }
        return stringArray3;
    }

    public static SparseArray createSparseArray(int[] nArray, Object[] objectArray) {
        if (nArray.length != objectArray.length) {
            throw new IllegalArgumentException("Repetitions and values must be of the same length.");
        }
        int[] nArray2 = new int[]{0};
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[0] = nArray2[0] + nArray[i];
        }
        SparseArray sparseArray = new SparseArray(nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            sparseArray.add(objectArray[i], nArray[i]);
        }
        sparseArray.finish();
        return sparseArray;
    }

    public static Vector stringArrayToVector(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    public static final int[] convertToBasicTypeArray(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public static final long[] convertToBasicTypeArray(Long[] longArray) {
        if (longArray == null) {
            return null;
        }
        long[] lArray = new long[longArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = longArray[i];
        }
        return lArray;
    }

    public static final short[] convertToBasicTypeArray(Short[] shortArray) {
        if (shortArray == null) {
            return null;
        }
        short[] sArray = new short[shortArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = shortArray[i];
        }
        return sArray;
    }

    public static final boolean[] convertToBasicTypeArray(Boolean[] booleanArray) {
        if (booleanArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[booleanArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = booleanArray[i];
        }
        return blArray;
    }

    public static final int[] convertIntegerListToIntArray(LinkedList linkedList) {
        if (linkedList == null || linkedList.size() == 0) {
            return null;
        }
        int[] nArray = new int[linkedList.size()];
        int n = 0;
        for (Integer n2 : linkedList) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public static final long[] convertLongListToLongArray(LinkedList linkedList) {
        if (linkedList == null || linkedList.size() == 0) {
            return null;
        }
        long[] lArray = new long[linkedList.size()];
        int n = 0;
        for (Long l : linkedList) {
            lArray[n++] = l;
        }
        return lArray;
    }

    public static final String[] convertStringListToStringArray(LinkedList linkedList) {
        if (linkedList == null || linkedList.size() == 0) {
            return null;
        }
        String[] stringArray = new String[linkedList.size()];
        int n = 0;
        for (String string : linkedList) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public static final short[] convertShortListToShortArray(LinkedList linkedList) {
        if (linkedList == null || linkedList.size() == 0) {
            return null;
        }
        short[] sArray = new short[linkedList.size()];
        int n = 0;
        for (Short s : linkedList) {
            sArray[n++] = s;
        }
        return sArray;
    }

    public static final Integer[] convertToBasicTypeEncapsulatorArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        return integerArray;
    }

    public static final Long[] convertToBasicTypeEncapsulatorArray(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            longArray[i] = new Long(lArray[i]);
        }
        return longArray;
    }

    public static final int findInArray(String string, String[] stringArray) {
        if (string != null && stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int findInArrayIgnoreCase(String string, String[] stringArray) {
        if (string != null && stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int findPrefixInArray(String string, String[] stringArray) {
        if (string != null && stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int findSuffixInArray(String string, String[] stringArray) {
        if (string != null && stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int findInArray(long l, long[] lArray) {
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] != l) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int findInArray(int n, int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int findInArray(short s, short[] sArray) {
        if (sArray != null && sArray.length > 0) {
            for (int i = 0; i < sArray.length; ++i) {
                if (sArray[i] != s) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int findInArray(byte by, byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != by) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int findInArray(Object object, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0 && object != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int countOccurences(Object object, Object[] objectArray) {
        int n = 0;
        if (objectArray != null && objectArray.length > 0 && object != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!object.equals(objectArray[i])) continue;
                ++n;
            }
        }
        return n;
    }

    public static final int[] concatArrays(int[] nArray, int[] nArray2) {
        int n = nArray == null ? 0 : nArray.length;
        int n2 = nArray2 == null ? 0 : nArray2.length;
        int[] nArray3 = new int[n + n2];
        if (nArray != null && n > 0) {
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        }
        if (nArray2 != null && n2 > 0) {
            System.arraycopy(nArray2, 0, nArray3, n, nArray2.length);
        }
        return nArray3;
    }

    public static final int[] concatArrays(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray == null ? 0 : nArray.length;
        int n2 = nArray2 == null ? 0 : nArray2.length;
        int n3 = nArray3 == null ? 0 : nArray3.length;
        int[] nArray4 = new int[n + n2 + n3];
        if (nArray != null && n > 0) {
            System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
        }
        if (nArray2 != null && n2 > 0) {
            System.arraycopy(nArray2, 0, nArray4, n, nArray2.length);
        }
        if (nArray3 != null && n3 > 0) {
            System.arraycopy(nArray3, 0, nArray4, n + n2, nArray3.length);
        }
        return nArray4;
    }

    public static final long[] concatArrays(long[] lArray, long[] lArray2) {
        int n = lArray == null ? 0 : lArray.length;
        int n2 = lArray2 == null ? 0 : lArray2.length;
        long[] lArray3 = new long[n + n2];
        if (lArray != null && n > 0) {
            System.arraycopy(lArray, 0, lArray3, 0, lArray.length);
        }
        if (lArray2 != null && n2 > 0) {
            System.arraycopy(lArray2, 0, lArray3, n, lArray2.length);
        }
        return lArray3;
    }

    public static final long[] concatArrays(long[] lArray, long[] lArray2, long[] lArray3) {
        int n = lArray == null ? 0 : lArray.length;
        int n2 = lArray2 == null ? 0 : lArray2.length;
        int n3 = lArray3 == null ? 0 : lArray3.length;
        long[] lArray4 = new long[n + n2 + n3];
        if (lArray != null && n > 0) {
            System.arraycopy(lArray, 0, lArray4, 0, lArray.length);
        }
        if (lArray2 != null && n2 > 0) {
            System.arraycopy(lArray2, 0, lArray4, n, lArray2.length);
        }
        if (lArray3 != null && n3 > 0) {
            System.arraycopy(lArray3, 0, lArray4, n + n2, lArray3.length);
        }
        return lArray4;
    }

    public static final String[] cloneArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public static final int[] cloneArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static final long[] cloneArray(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        long[] lArray2 = new long[lArray.length];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        return lArray2;
    }

    public static final long[] stringArrayToLongArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = Long.parseLong(stringArray[i]);
        }
        return lArray;
    }

    public static final int[] stringArrayToIntArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static final String[] longArrayToStringArray(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        String[] stringArray = new String[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            stringArray[i] = lArray[i] + "";
        }
        return stringArray;
    }

    public static final String[] intArrayToStringArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = nArray[i] + "";
        }
        return stringArray;
    }

    public static final String[] byteArrayToStringArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String[] stringArray = new String[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            stringArray[i] = byArray[i] + "";
        }
        return stringArray;
    }

    public static final String[] unsignedByteArrayToStringArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String[] stringArray = new String[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            stringArray[i] = (byArray[i] & 0xFF) + "";
        }
        return stringArray;
    }

    public static final String shortArrayToString(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < sArray.length; ++i) {
            string = string + sArray[i];
            if (i == sArray.length - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public static final String booleanArrayToString(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < blArray.length; ++i) {
            string = string + blArray[i];
            if (i == blArray.length - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public static final String[] appendToArray(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    public static final int[] appendToArray(int n, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return new int[]{n};
        }
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = n;
        return nArray2;
    }

    public static final short[] appendToArray(short s, short[] sArray) {
        if (sArray == null || sArray.length == 0) {
            return new short[]{s};
        }
        short[] sArray2 = new short[sArray.length + 1];
        System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
        sArray2[sArray.length] = s;
        return sArray2;
    }

    public static final long[] appendToArray(long l, long[] lArray) {
        if (lArray == null || lArray.length == 0) {
            return new long[]{l};
        }
        long[] lArray2 = new long[lArray.length + 1];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        lArray2[lArray.length] = l;
        return lArray2;
    }

    public static final boolean[] appendToArray(boolean bl, boolean[] blArray) {
        if (blArray == null || blArray.length == 0) {
            return new boolean[]{bl};
        }
        boolean[] blArray2 = new boolean[blArray.length + 1];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        blArray2[blArray.length] = bl;
        return blArray2;
    }

    public static final Integer[] appendToArray(Integer n, Integer[] integerArray) {
        if (integerArray == null || integerArray.length == 0) {
            return new Integer[]{n};
        }
        Integer[] integerArray2 = new Integer[integerArray.length + 1];
        System.arraycopy(integerArray, 0, integerArray2, 0, integerArray.length);
        integerArray2[integerArray.length] = n;
        return integerArray2;
    }
}

