/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.time.Timestamp;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Category;

public class BufferedInputStream
extends FilterInputStream {
    private static final int BYTE_MASK = 255;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    static int defaultBufferSize = 32768;
    protected byte[] buf;
    protected int length;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;
    protected long lastFillTime = Long.MAX_VALUE;
    private static Category logcat = Category.getInstance(BufferedInputStream.class);

    public String toString() {
        return super.toString();
    }

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, defaultBufferSize);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n];
    }

    public int getSize() {
        return this.buf.length;
    }

    public final int getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fill() throws IOException {
        if (this.in.available() > 0) {
            BufferedInputStream bufferedInputStream = this;
            synchronized (bufferedInputStream) {
                if (this.in.available() > 0) {
                    this.fill0();
                }
            }
        }
        return this.lastFillTime;
    }

    private final boolean filluntil(int n) throws IOException {
        int n2 = (this.pos + this.length) % this.buf.length;
        if (n2 < n) {
            int n3 = this.in.read(this.buf, n2, n - n2);
            if (n3 > 0) {
                this.length += n3;
                return true;
            }
            return false;
        }
        int n4 = this.in.read(this.buf, n2, this.buf.length - n2);
        if (n4 > 0) {
            this.length += n4;
        } else {
            return false;
        }
        if (this.length < this.buf.length && this.pos + this.length == this.buf.length && this.in.available() > 0 && (n4 = this.in.read(this.buf, 0, n)) > 0) {
            this.length += n4;
        }
        return true;
    }

    private void fill0() throws IOException {
        boolean bl = false;
        if (this.markpos < 0) {
            if (this.length < this.buf.length) {
                bl = this.filluntil(this.pos);
            } else {
                logcat.debug((Object)"No more space in the buffer");
            }
        } else {
            int n;
            int n2;
            int n3 = n2 = this.pos >= this.markpos ? this.pos - this.markpos + this.length : this.buf.length - this.markpos + this.pos + this.length;
            if (n2 > this.marklimit) {
                this.markpos = -1;
                this.fill0();
                return;
            }
            if ((this.pos + 1 + this.length) % this.buf.length == this.markpos) {
                if (logcat.isDebugEnabled()) {
                    logcat.debug((Object)("+pos=" + this.pos + ",markpos=" + this.markpos + ",length=" + this.length + ",size=" + this.buf.length));
                }
                n = this.buf.length << 1;
                byte[] byArray = new byte[n];
                System.arraycopy(this.buf, this.markpos, byArray, 0, this.buf.length - this.markpos);
                System.arraycopy(this.buf, 0, byArray, this.buf.length - this.markpos, this.markpos);
                this.pos = this.pos >= this.markpos ? this.pos - this.markpos : this.buf.length - this.markpos + this.pos;
                this.markpos = 0;
                this.buf = byArray;
                if (logcat.isDebugEnabled()) {
                    logcat.debug((Object)("-pos=" + this.pos + ",markpos=" + this.markpos + ",length=" + this.length + ",size=" + this.buf.length));
                }
            }
            n = this.markpos > 0 ? this.markpos - 1 : this.buf.length - 1;
            bl = this.filluntil(n);
        }
        if (bl) {
            this.lastFillTime = Timestamp.getCurrentTimeStampInMilli();
        }
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.length == 0) {
            this.fill0();
            if (this.length == 0) {
                return -1;
            }
        }
        --this.length;
        int n = this.pos;
        this.pos = (this.pos + 1) % this.buf.length;
        return this.buf[n] & 0xFF;
    }

    private int read1(byte[] byArray, int n, int n2) throws IOException {
        if (this.length == 0) {
            if (n2 >= this.buf.length && this.markpos < 0) {
                return this.in.read(byArray, n, n2);
            }
            this.fill0();
            if (this.length <= 0) {
                return -1;
            }
        }
        int n3 = this.length < n2 ? this.length : n2;
        this.bufCopy(byArray, n, n3);
        this.pos = (this.pos + n3) % this.buf.length;
        this.length -= n3;
        return n3;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.ensureOpen();
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.read1(byArray, n, n2);
        if (n4 <= 0) {
            return n4;
        }
        while (n4 < n2 && this.in.available() > 0 && (n3 = this.read1(byArray, n + n4, n2 - n4)) > 0) {
            n4 += n3;
        }
        return n4;
    }

    private final void bufCopy(byte[] byArray, int n, int n2) {
        if (this.buf.length >= this.pos + n2) {
            System.arraycopy(this.buf, this.pos, byArray, n, n2);
        } else {
            int n3 = this.buf.length - this.pos;
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            System.arraycopy(this.buf, 0, byArray, n + n3, n2 - n3);
        }
    }

    public synchronized long skip(long l) throws IOException {
        this.ensureOpen();
        if (l <= 0L) {
            return 0L;
        }
        if (this.length <= 0) {
            if (this.markpos < 0) {
                return this.in.skip(l);
            }
            this.fill0();
            if (this.length <= 0) {
                return 0L;
            }
        }
        long l2 = (long)this.length < l ? (long)this.length : l;
        this.pos = (int)((long)this.pos + l2);
        this.length = (int)((long)this.length - l2);
        return l2;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.length + this.in.available();
    }

    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.length = this.pos > this.markpos ? this.length + this.pos - this.markpos : this.length + this.buf.length + this.pos - this.markpos;
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }

    private final void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    final void my_assert(boolean bl) {
        if (!bl) {
            throw new IllegalStateException("assertion failed");
        }
    }
}

