/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import java.io.Serializable;
import java.util.StringTokenizer;

public class Community
implements Cloneable,
Serializable {
    public static final long INVALID_COMMUNITY = -1L;
    long community;
    String vpnName;

    public Community() {
        this.community = 0L;
        this.vpnName = "";
    }

    public Community(long l, String string) {
        this.community = l;
        this.vpnName = string;
    }

    public Community(String string, String string2) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = stringTokenizer.countTokens();
        if (n == 2) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            int n3 = Integer.parseInt(string4);
            this.set(n2, n3, string2);
        } else {
            if (string.length() < 3) {
                throw new IllegalArgumentException("community value is too short (" + string + ')');
            }
            if (string.charAt(0) != '0' && string.charAt(1) != 'x') {
                throw new IllegalArgumentException("bad format for community (" + string + ')');
            }
            this.community = Long.parseLong(string.substring(2), 16);
            this.vpnName = string2;
        }
    }

    public Community(int n, int n2, String string) {
        this.set(n, n2, string);
    }

    private void set(int n, int n2, String string) {
        if (n > 65535 || n < 0) {
            throw new IllegalArgumentException("AS " + n + " is not in the range [0-65535]");
        }
        if (n2 > 65535 || n2 < 0) {
            throw new IllegalArgumentException("VAL " + n2 + " is not in the range [0-65535]");
        }
        this.community = (long)n << 16 | (long)n2 & 0xFFFFL;
        this.vpnName = string;
    }

    public final String getVpn() {
        return this.vpnName;
    }

    public final long getCommunity() {
        return this.community;
    }

    public String getCommunityAsString() {
        long l = (this.community & 0xFFFF0000L) >> 16;
        long l2 = this.community & 0xFFFFL;
        return Long.toString(l) + ':' + Long.toString(l2) + '@' + this.vpnName;
    }

    public String toString() {
        return this.getCommunityAsString();
    }
}

