/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;

public class CompleteConfFile
implements Serializable {
    protected LinkedList sections = new LinkedList();
    protected LinkedList internalErrorList = new LinkedList();
    protected LinkedList errorList = new LinkedList();
    protected LinkedList warningsList = new LinkedList();
    protected boolean overrideValuesBySystemProperties = false;
    protected String[] lastComments;

    public String toString() {
        return super.toString();
    }

    public final void setLastComments(String[] stringArray) {
        this.lastComments = stringArray;
    }

    public final String[] getLastComments() {
        return this.lastComments;
    }

    public void readConfFile(Reader reader) throws IOException {
        ConfFileParser confFileParser = new ConfFileParser(reader, this);
        confFileParser.parse();
    }

    public void writeConfFile(Writer writer) throws IOException {
        ConfFileWriter confFileWriter = new ConfFileWriter(writer, this);
        confFileWriter.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfFile(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        try {
            this.readConfFile(fileReader);
        }
        finally {
            fileReader.close();
        }
    }

    public void readConfFile(InputStream inputStream) throws IOException {
        this.readConfFile(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfFile(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        try {
            this.writeConfFile(fileWriter);
        }
        finally {
            fileWriter.close();
        }
    }

    public void writeConfFile(OutputStream outputStream) throws IOException {
        this.writeConfFile(new OutputStreamWriter(outputStream));
    }

    public String toPrintableString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeConfFile(byteArrayOutputStream);
            String string = new String(byteArrayOutputStream.toByteArray());
            return string;
        }
        catch (IOException iOException) {
            String string = "Error occured when translating configuration to string: " + iOException;
            return string;
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeConfFile(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void fromByteArray(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.readConfFile(byteArrayInputStream);
    }

    public Properties getSection(String string) {
        Section section = this.internalGetSection(string, false);
        if (section != null) {
            return CompleteConfFile.convertPropertyListToProperties(section.properties);
        }
        return null;
    }

    public Section getSection1(String string) {
        return this.internalGetSection(string, false);
    }

    public boolean addSection(String string) {
        return this.addSection(string, null);
    }

    public boolean addSection(String string, Properties properties) {
        return this.addSection(string, CompleteConfFile.convertPropertiesToPropertyArray(properties), null);
    }

    public boolean addSection(String string, Property[] propertyArray, String[] stringArray) {
        if (CompleteConfFile.nameExists(string, this.sections, true)) {
            this.internalErrorList.add("Section " + string + " added when already exists");
            this.addError("Section " + string + " added when already exists");
            return false;
        }
        Section section = new Section(string, propertyArray, stringArray);
        this.sections.add(section);
        return true;
    }

    public boolean removeSection(String string) {
        boolean bl = CompleteConfFile.removeItem(string, this.sections, true);
        if (!bl) {
            this.internalErrorList.add("Section " + string + " was not found (to be removed)");
        }
        return bl;
    }

    public boolean removeProperty(String string, String string2) {
        Section section = this.internalGetSection(string, true);
        if (section == null) {
            this.internalErrorList.add("Property " + string2 + " in section " + string + " was not found (to be removed)");
            return false;
        }
        return CompleteConfFile.removeItem(string2, section.properties, true);
    }

    public Enumeration getSectionEnumeration() {
        return this.getFileOrderSectionsEnumeration();
    }

    public Enumeration getFileOrderSectionsEnumeration() {
        return new Enumeration(){
            Iterator iter;
            {
                this.iter = CompleteConfFile.this.sections.iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return ((Section)this.iter.next()).getName();
            }
        };
    }

    public Section[] getSections() {
        int n = this.sections.size();
        return this.sections.toArray(new Section[n]);
    }

    public Vector getPropertyList(String string, String string2) {
        try {
            Section section = this.internalGetSection(string, true);
            Property property = section.getProperty(string2);
            if (property != null) {
                return property.translateValueToCommandDelemitedFields();
            }
            this.internalErrorList.add("Property " + string2 + " in section " + string + " was not found (requested)");
            return null;
        }
        catch (Exception exception) {
            this.internalErrorList.add("Property " + string2 + " in section " + string + " was not found (requested):" + exception.getMessage());
            return null;
        }
    }

    public void setPropertyList(String string, String string2, Vector vector) {
        Section section = this.internalGetSection(string, true);
        Property property = section.getProperty(string2);
        if (property == null) {
            section.setProperty(string2, null, null);
            property = section.getProperty(string2);
        }
        property.setValueAsCommaDelimitedFields(vector);
    }

    public Property[] getProperties(String string) {
        Section section = this.internalGetSection(string, true);
        if (section == null) {
            return null;
        }
        return section.getProperties();
    }

    public String getProperty(String string, String string2) {
        return this.getProperty(string, string2, null);
    }

    public String getProperty(String string, String string2, String string3) {
        Object object;
        Section section = this.internalGetSection(string, false);
        if (this.overrideValuesBySystemProperties && (object = System.getProperty(string + '.' + string2)) != null) {
            return object;
        }
        if (section == null) {
            if (string3 == null) {
                this.internalErrorList.add("Section " + string + " not found (get property)");
            }
            return string3;
        }
        object = section.getProperty(string2);
        if (object == null) {
            if (string3 == null) {
                this.internalErrorList.add("Property " + string2 + " in section " + string + " was not found (get property)");
            }
            return string3;
        }
        return ((Property)object).value;
    }

    public boolean isPropertyExist(String string, String string2) {
        return this.getProperty(string, string2, null) != null;
    }

    public void setProperty(String string, String string2, String string3) {
        this.setProperty(string, string2, string3, null);
    }

    public void setProperty(String string, String string2, String string3, String[] stringArray) {
        Section section = this.internalGetSection(string, true);
        section.setProperty(string2, string3, stringArray);
    }

    public String getStringParam(String string, String string2, String string3) {
        return this.getProperty(string, string2, string3);
    }

    public int getIntParam(String string, String string2, int n) {
        try {
            return Integer.parseInt(this.getProperty(string, string2, n + ""));
        }
        catch (NumberFormatException numberFormatException) {
            this.errorList.add("Bad value in configuration file, [" + string + "] " + string2 + " is not a number.");
            return n;
        }
    }

    public float getFloatParam(String string, String string2, float f) {
        try {
            return Float.parseFloat(this.getProperty(string, string2, f + ""));
        }
        catch (NumberFormatException numberFormatException) {
            this.errorList.add("Bad value in configuration file, [" + string + "] " + string2 + " is not a number.");
            return f;
        }
    }

    public boolean getBooleanParam(String string, String string2, boolean bl) {
        String string3 = this.getProperty(string, string2, bl + "");
        if (string3 == null) {
            return bl;
        }
        if (!(string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("no") || string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("false") || string3.equalsIgnoreCase("1") || string3.equalsIgnoreCase("0"))) {
            this.errorList.add("Bad value in configuration file, [" + string + "] " + string2 + " is not a boolean value.");
            return bl;
        }
        return string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("1");
    }

    public double getDoubleParam(String string, String string2, double d) {
        try {
            return Double.parseDouble(this.getProperty(string, string2, d + ""));
        }
        catch (NumberFormatException numberFormatException) {
            this.errorList.add("Bad value in configuration file, [" + string + "] " + string2 + " is not a number.");
            return d;
        }
    }

    public short getShortParam(String string, String string2, short s) {
        try {
            return Short.parseShort(this.getProperty(string, string2, s + ""));
        }
        catch (NumberFormatException numberFormatException) {
            this.errorList.add("Bad value in configuration file, [" + string + "] " + string2 + " is not a number.");
            return s;
        }
    }

    public long getLongParam(String string, String string2, long l) {
        try {
            return Long.parseLong(this.getProperty(string, string2, l + ""));
        }
        catch (NumberFormatException numberFormatException) {
            this.errorList.add("Bad value in configuration file, [" + string + "] " + string2 + " is not a number.");
            return l;
        }
    }

    public boolean hasKey(String string, String string2) {
        Section section = this.internalGetSection(string, false);
        return section != null && section.getProperty(string2) != null;
    }

    public boolean addDefault(String string, String string2, String string3) {
        Section section = this.internalGetSection(string, false);
        if (section != null && section.getProperty(string2) == null) {
            section.setProperty(string2, string3, null);
            return true;
        }
        return false;
    }

    public Section[] getSections(Filter filter) {
        LinkedList<Section> linkedList = new LinkedList<Section>();
        for (Section section : this.sections) {
            if (filter != null && !filter.acceptSection(section)) continue;
            linkedList.add(section);
        }
        return linkedList.toArray(new Section[linkedList.size()]);
    }

    public Property[] getProperties(Filter filter) {
        Section[] sectionArray = this.getSections(filter);
        LinkedList<Property> linkedList = new LinkedList<Property>();
        for (int i = 0; i < sectionArray.length; ++i) {
            Property[] propertyArray = this.getProperties(sectionArray[i], filter);
            for (int j = 0; j < propertyArray.length; ++j) {
                linkedList.add(propertyArray[j]);
            }
        }
        return linkedList.toArray(new Property[linkedList.size()]);
    }

    public Property[] getProperties(Section section, Filter filter) {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        for (Property property : section.properties) {
            if (filter != null && !filter.acceptProperty(section, property)) continue;
            linkedList.add(property);
        }
        return linkedList.toArray(new Property[linkedList.size()]);
    }

    public int getNumberOfErrors() {
        return this.errorList.size();
    }

    public String[] getErrors() {
        return this.errorList.toArray(new String[this.errorList.size()]);
    }

    public void resetErrorList() {
        this.errorList = new LinkedList();
    }

    public void addError(String string) {
        this.errorList.add(string);
    }

    public void addErrors(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addError(stringArray[i]);
        }
    }

    public int getNumberOfWarnings() {
        return this.warningsList.size();
    }

    public String[] getWarnings() {
        return this.warningsList.toArray(new String[this.warningsList.size()]);
    }

    public void resetWarningList() {
        this.warningsList = new LinkedList();
    }

    public void addWarning(String string) {
        this.warningsList.add(string);
    }

    public void addWarnings(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addWarning(stringArray[i]);
        }
    }

    public final void setOverrideValuesBySystemProperties(boolean bl) {
        this.overrideValuesBySystemProperties = bl;
    }

    public boolean areValuesOverriddenBySystemProperties() {
        return this.overrideValuesBySystemProperties;
    }

    private Section internalGetSection(String string, boolean bl) throws IllegalArgumentException {
        Section section = (Section)CompleteConfFile.fetchHasNameFromList(string, this.sections, true);
        if (section == null && bl) {
            throw new IllegalArgumentException("Section " + string + " not found");
        }
        return section;
    }

    static final boolean nameExists(String string, LinkedList linkedList, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        String string2 = bl ? string : string.toLowerCase();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string3 = ((HasName)iterator.next()).getName();
            string3 = bl ? string3 : string3.toLowerCase();
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    static final Property[] convertPropertiesToPropertyArray(Properties properties) {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        if (properties != null) {
            for (String string : properties.keySet()) {
                String string2 = properties.getProperty(string);
                linkedList.add(new Property(string, string2, null));
            }
            Collections.sort(linkedList);
        }
        return linkedList.toArray(new Property[linkedList.size()]);
    }

    static final Properties convertPropertyListToProperties(LinkedList linkedList) {
        Properties properties = new Properties();
        for (Property property : linkedList) {
            properties.setProperty(property.name, property.value);
        }
        return properties;
    }

    static final HasName fetchHasNameFromList(String string, LinkedList linkedList, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        String string2 = bl ? string : string.toLowerCase();
        for (HasName hasName : linkedList) {
            String string3 = bl ? hasName.getName() : hasName.getName().toLowerCase();
            if (!string3.equals(string2)) continue;
            return hasName;
        }
        return null;
    }

    static final boolean removeItem(String string, LinkedList linkedList, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        String string2 = bl ? string : string.toLowerCase();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            HasName hasName = (HasName)iterator.next();
            String string3 = bl ? hasName.getName() : hasName.getName().toLowerCase();
            if (!string3.equals(string2)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    static class ConfFileWriter {
        private static final int INT_VALUE_12 = 12;
        private static final String SPECIAL_SAVE_CHARS = "= \t\r\n\f#!";
        private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        private BufferedWriter writer;
        private CompleteConfFile confFile;

        public String toString() {
            return super.toString();
        }

        ConfFileWriter(Writer writer, CompleteConfFile completeConfFile) {
            this.confFile = completeConfFile;
            this.writer = new BufferedWriter(writer);
        }

        void write() throws IOException {
            Section[] sectionArray = this.confFile.getSections();
            for (int i = 0; i < sectionArray.length; ++i) {
                this.writeSection(sectionArray[i]);
            }
            String[] stringArray = this.confFile.getLastComments();
            if (stringArray != null) {
                this.writeComments(stringArray);
            }
            this.writer.flush();
        }

        private void writeSection(Section section) throws IOException {
            this.writeComments(section.getComments());
            this.writer.write('[' + section.getName() + ']');
            this.writer.newLine();
            Property[] propertyArray = section.getProperties();
            for (int i = 0; i < propertyArray.length; ++i) {
                this.writeProperty(propertyArray[i]);
            }
        }

        private void writeProperty(Property property) throws IOException {
            this.writeComments(property.getComments());
            String string = this.saveConvert(property.getName(), true);
            String string2 = this.saveConvert(property.getValue(), false);
            this.writer.write(string + '=' + string2);
            this.writer.newLine();
            this.writer.newLine();
        }

        private void writeComments(String[] stringArray) throws IOException {
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                this.writer.write(stringArray[i]);
                this.writer.newLine();
            }
        }

        private String saveConvert(String string, boolean bl) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n * 2);
            block8: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ' ': {
                        if (i == 0 || bl) {
                            stringBuffer.append('\\');
                        }
                        stringBuffer.append(' ');
                        continue block8;
                    }
                    case '\\': {
                        stringBuffer.append('\\');
                        stringBuffer.append('\\');
                        continue block8;
                    }
                    case '\t': {
                        stringBuffer.append('\\');
                        stringBuffer.append('t');
                        continue block8;
                    }
                    case '\n': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        continue block8;
                    }
                    case '\r': {
                        stringBuffer.append('\\');
                        stringBuffer.append('r');
                        continue block8;
                    }
                    case '\f': {
                        stringBuffer.append('\\');
                        stringBuffer.append('f');
                        continue block8;
                    }
                    default: {
                        if (c < ' ' || c > '~') {
                            stringBuffer.append('\\');
                            stringBuffer.append('u');
                            stringBuffer.append(ConfFileWriter.toHex(c >> 12 & 0xF));
                            stringBuffer.append(ConfFileWriter.toHex(c >> 8 & 0xF));
                            stringBuffer.append(ConfFileWriter.toHex(c >> 4 & 0xF));
                            stringBuffer.append(ConfFileWriter.toHex(c & 0xF));
                            continue block8;
                        }
                        if (SPECIAL_SAVE_CHARS.indexOf(c) != -1) {
                            stringBuffer.append('\\');
                        }
                        stringBuffer.append(c);
                    }
                }
            }
            return stringBuffer.toString();
        }

        private static char toHex(int n) {
            return HEX_DIGITS[n & 0xF];
        }
    }

    static class ConfFileParser {
        private static final String KEY_VALUE_SEPARATORS = "=";
        private static final String STRICT_KEY_VALUE_SEPARATORS = "=";
        private static final String WHITE_SPACE_CHARS = " \t\r\n\f";
        private static final int TYPE_SECTION = 0;
        private static final int TYPE_COMMENT = 1;
        private static final int TYPE_PROPERTY = 2;
        private static final int TYPE_EMPTY = 3;
        private static final int TYPE_EOF = 4;
        private String currentLine;
        private int currentLineNumber;
        private BufferedReader reader;
        private CompleteConfFile confFile;

        public String toString() {
            return super.toString();
        }

        ConfFileParser(Reader reader, CompleteConfFile completeConfFile) throws IOException {
            this.reader = new BufferedReader(reader);
            this.confFile = completeConfFile;
            this.currentLineNumber = 0;
            this.consume();
        }

        void parse() throws IOException {
            String[] stringArray = null;
            String string = null;
            int n = this.currentLineType();
            while (n != 4) {
                switch (n) {
                    case 3: {
                        this.consume();
                        break;
                    }
                    case 1: {
                        stringArray = this.readComments();
                        break;
                    }
                    case 0: {
                        String string2 = this.readSectionName();
                        if (string2 != null) {
                            string = string2;
                            this.confFile.addSection(string2, null, stringArray);
                            stringArray = null;
                            break;
                        }
                        this.confFile.errorList.add("Parse error at line " + this.currentLineNumber + " could not read section");
                        break;
                    }
                    case 2: {
                        String[] stringArray2 = this.readProperty();
                        if (string != null) {
                            if (this.confFile.isPropertyExist(string, stringArray2[0])) {
                                this.confFile.errorList.add("Parse error at line " + (this.currentLineNumber - 1) + " duplicate property name");
                            }
                            this.confFile.setProperty(string, stringArray2[0], stringArray2[1], stringArray);
                            stringArray = null;
                            break;
                        }
                        this.confFile.errorList.add("Parse error at line " + this.currentLineNumber + " property that doesn't have a section");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unreachable point reached");
                    }
                }
                n = this.currentLineType();
            }
            this.confFile.setLastComments(stringArray);
        }

        private int currentLineType() {
            if (this.currentLine == null) {
                return 4;
            }
            String string = this.currentLine.trim();
            if (string.length() == 0) {
                return 3;
            }
            if (this.currentLine.charAt(0) == '#') {
                return 1;
            }
            if (string.charAt(0) == '[' && string.endsWith("]")) {
                return 0;
            }
            return 2;
        }

        private void consume() throws IOException {
            this.currentLine = this.reader.readLine();
            ++this.currentLineNumber;
        }

        private String readSectionName() throws IOException {
            String string = this.currentLine.trim();
            if (string.length() < 3) {
                this.confFile.errorList.add("Parse error, at line " + this.currentLineNumber + " illegal section name");
                return null;
            }
            String string2 = string.substring(1, string.length() - 1);
            this.consume();
            return string2;
        }

        private String[] readComments() throws IOException {
            LinkedList<String> linkedList = new LinkedList<String>();
            boolean bl = false;
            block4: while (!bl) {
                switch (this.currentLineType()) {
                    case 0: 
                    case 2: 
                    case 4: {
                        bl = true;
                        continue block4;
                    }
                    case 1: 
                    case 3: {
                        linkedList.add(this.currentLine);
                        this.consume();
                        continue block4;
                    }
                }
                throw new IllegalStateException("unreachable point reached");
            }
            return linkedList.toArray(new String[linkedList.size()]);
        }

        private String[] readProperty() throws IOException {
            int n;
            int n2;
            int n3;
            int n4 = this.currentLine.length();
            for (n3 = 0; n3 < n4 && WHITE_SPACE_CHARS.indexOf(this.currentLine.charAt(n3)) != -1; ++n3) {
            }
            int n5 = -1;
            for (n2 = n3; n2 < n4; ++n2) {
                n = this.currentLine.charAt(n2);
                if (n == 92) {
                    ++n2;
                    n5 = -1;
                    continue;
                }
                if ("=".indexOf(n) != -1) break;
                if (WHITE_SPACE_CHARS.indexOf(n) != -1) {
                    if (n5 != -1) continue;
                    n5 = n2;
                    continue;
                }
                n5 = -1;
            }
            if (n5 != -1) {
                n2 = n5;
            }
            for (n = n2; n < n4 && WHITE_SPACE_CHARS.indexOf(this.currentLine.charAt(n)) != -1; ++n) {
            }
            if (n < n4 && "=".indexOf(this.currentLine.charAt(n)) != -1) {
                ++n;
            }
            while (n < n4 && WHITE_SPACE_CHARS.indexOf(this.currentLine.charAt(n)) != -1) {
                ++n;
            }
            String string = this.currentLine.substring(n3, n2);
            String string2 = n2 < n4 ? this.currentLine.substring(n, n4) : "";
            string = this.loadConvert(string);
            string2 = this.loadConvert(string2.trim());
            this.consume();
            return new String[]{string, string2};
        }

        private String loadConvert(String string) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                if ((n3 = string.charAt(n2++)) == 92) {
                    if ((n3 = string.charAt(n2++)) == 117) {
                        int n4 = 0;
                        block6: for (int i = 0; i < 4; ++i) {
                            n3 = string.charAt(n2++);
                            switch (n3) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    n4 = (n4 << 4) + n3 - 48;
                                    continue block6;
                                }
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    n4 = (n4 << 4) + 10 + n3 - 97;
                                    continue block6;
                                }
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: {
                                    n4 = (n4 << 4) + 10 + n3 - 65;
                                    continue block6;
                                }
                                default: {
                                    throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                }
                            }
                        }
                        stringBuffer.append((char)n4);
                        continue;
                    }
                    if (n3 == 116) {
                        n3 = 9;
                    } else if (n3 == 114) {
                        n3 = 13;
                    } else if (n3 == 110) {
                        n3 = 10;
                    } else if (n3 == 102) {
                        n3 = 12;
                    }
                    stringBuffer.append((char)n3);
                    continue;
                }
                stringBuffer.append((char)n3);
            }
            return stringBuffer.toString();
        }
    }

    public static class Property
    implements HasName,
    Comparable,
    Serializable {
        String[] comments;
        String name;
        String value;

        public String toString() {
            return super.toString();
        }

        Property(String string, String string2, String[] stringArray) {
            if (string == null) {
                throw new IllegalArgumentException("null name");
            }
            this.name = string;
            this.value = string2 == null ? "" : string2;
            this.comments = stringArray;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String[] getComments() {
            return this.comments;
        }

        public int compareTo(Object object) {
            Property property = (Property)object;
            return this.name.compareTo(property.name);
        }

        public Vector translateValueToCommandDelemitedFields() {
            Vector<String> vector = new Vector<String>();
            String string = this.value;
            if (string != null && string.trim().length() > 0) {
                while (string.indexOf(44) != -1) {
                    int n = string.indexOf(44);
                    String string2 = string.substring(0, n);
                    vector.addElement(string2.trim());
                    string = string.substring(n + 1);
                }
                vector.addElement(string.trim());
            }
            return vector;
        }

        public void setValueAsCommaDelimitedFields(Vector vector) {
            if (vector == null || vector.size() < 1) {
                throw new IllegalArgumentException("fields should not be null and contain at least a single value");
            }
            this.value = (String)vector.firstElement();
            int n = vector.size();
            for (int i = 1; i < n; ++i) {
                this.value = this.value + ',' + (String)vector.elementAt(i);
            }
        }
    }

    public static class Section
    implements HasName,
    Serializable {
        String name;
        LinkedList properties;
        String[] comments;

        public String toString() {
            return super.toString();
        }

        Section(String string, Property[] propertyArray, String[] stringArray) {
            if (string == null) {
                throw new IllegalArgumentException("null name");
            }
            this.name = string;
            this.properties = new LinkedList();
            for (int i = 0; propertyArray != null && i < propertyArray.length; ++i) {
                this.properties.add(propertyArray[i]);
            }
            this.comments = stringArray;
        }

        public String getName() {
            return this.name;
        }

        public String[] getComments() {
            return this.comments;
        }

        public void setProperty(String string, String string2, String[] stringArray) {
            Property property = (Property)CompleteConfFile.fetchHasNameFromList(string, this.properties, true);
            if (property == null) {
                property = new Property(string, string2, stringArray);
                this.properties.add(property);
            } else {
                String string3 = property.value = string2 == null ? "" : string2;
                if (stringArray != null) {
                    property.comments = stringArray;
                }
            }
        }

        public Property getProperty(String string) {
            return (Property)CompleteConfFile.fetchHasNameFromList(string, this.properties, true);
        }

        public Property[] getProperties() {
            int n = this.properties.size();
            return this.properties.toArray(new Property[n]);
        }

        public Property[] getProperties(Filter filter) {
            LinkedList<Property> linkedList = new LinkedList<Property>();
            for (Property property : this.properties) {
                if (filter != null && !filter.acceptProperty(this, property)) continue;
                linkedList.add(property);
            }
            return linkedList.toArray(new Property[linkedList.size()]);
        }

        public Vector getPropertyList(String string) {
            try {
                Property property = this.getProperty(string);
                if (property != null) {
                    return property.translateValueToCommandDelemitedFields();
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    static interface HasName {
        public String getName();
    }

    public static interface Filter {
        public boolean acceptSection(Section var1);

        public boolean acceptProperty(Section var1, Property var2);
    }
}

